/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMUtilities;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class PEMWriter
extends BufferedWriter {
    private String provider;

    public PEMWriter(Writer writer) {
        this(writer, "BC");
    }

    public PEMWriter(Writer writer, String string) {
        super(writer);
        this.provider = string;
    }

    private void writeHexEncoded(byte[] byArray) throws IOException {
        byArray = Hex.encode(byArray);
        int n = 0;
        while (n != byArray.length) {
            this.write((char)byArray[n]);
            ++n;
        }
    }

    private void writeEncoded(byte[] byArray) throws IOException {
        char[] cArray = new char[64];
        byArray = Base64.encode(byArray);
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            while (n2 != cArray.length) {
                if (n + n2 >= byArray.length) break;
                cArray[n2] = (char)byArray[n + n2];
                ++n2;
            }
            this.write(cArray, 0, n2);
            this.newLine();
            n += cArray.length;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObject(Object object) throws IOException {
        byte[] byArray;
        String string;
        if (object instanceof X509Certificate) {
            string = "CERTIFICATE";
            try {
                byArray = ((X509Certificate)object).getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Cannot encode object: " + certificateEncodingException.toString());
            }
        } else if (object instanceof X509CRL) {
            string = "X509 CRL";
            try {
                byArray = ((X509CRL)object).getEncoded();
            }
            catch (CRLException cRLException) {
                throw new IOException("Cannot encode object: " + cRLException.toString());
            }
        } else {
            if (object instanceof KeyPair) {
                this.writeObject(((KeyPair)object).getPrivate());
                return;
            }
            if (object instanceof PrivateKey) {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(((Key)object).getEncoded()));
                if (object instanceof RSAPrivateKey) {
                    string = "RSA PRIVATE KEY";
                    byArray = privateKeyInfo.getPrivateKey().getEncoded();
                } else if (object instanceof DSAPrivateKey) {
                    string = "DSA PRIVATE KEY";
                    DSAParameter dSAParameter = DSAParameter.getInstance(privateKeyInfo.getAlgorithmId().getParameters());
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    aSN1EncodableVector.add(new DERInteger(0));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getP()));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getQ()));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getG()));
                    BigInteger bigInteger = ((DSAPrivateKey)object).getX();
                    BigInteger bigInteger2 = dSAParameter.getG().modPow(bigInteger, dSAParameter.getP());
                    aSN1EncodableVector.add(new DERInteger(bigInteger2));
                    aSN1EncodableVector.add(new DERInteger(bigInteger));
                    byArray = new DERSequence(aSN1EncodableVector).getEncoded();
                } else {
                    if (!((PrivateKey)object).getAlgorithm().equals("ECDSA")) throw new IOException("Cannot identify private key");
                    string = "EC PRIVATE KEY";
                    byArray = privateKeyInfo.getPrivateKey().getEncoded();
                }
            } else if (object instanceof PublicKey) {
                string = "PUBLIC KEY";
                byArray = ((PublicKey)object).getEncoded();
            } else if (object instanceof X509AttributeCertificate) {
                string = "ATTRIBUTE CERTIFICATE";
                byArray = ((X509V2AttributeCertificate)object).getEncoded();
            } else if (object instanceof PKCS10CertificationRequest) {
                string = "CERTIFICATE REQUEST";
                byArray = ((PKCS10CertificationRequest)object).getEncoded();
            } else {
                if (!(object instanceof ContentInfo)) throw new IOException("unknown object passed - can't encode.");
                string = "PKCS7";
                byArray = ((ContentInfo)object).getEncoded();
            }
        }
        this.writeHeader(string);
        this.writeEncoded(byArray);
        this.writeFooter(string);
    }

    public void writeObject(Object object, String string, char[] cArray, SecureRandom secureRandom) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (object instanceof KeyPair) {
            this.writeObject(((KeyPair)object).getPrivate());
            return;
        }
        String string2 = null;
        byte[] byArray = null;
        if (object instanceof RSAPrivateCrtKey) {
            string2 = "RSA PRIVATE KEY";
            object5 = (RSAPrivateCrtKey)object;
            object4 = new RSAPrivateKeyStructure(object5.getModulus(), object5.getPublicExponent(), object5.getPrivateExponent(), object5.getPrimeP(), object5.getPrimeQ(), object5.getPrimeExponentP(), object5.getPrimeExponentQ(), object5.getCrtCoefficient());
            byArray = ((ASN1Encodable)object4).getEncoded();
        } else if (object instanceof DSAPrivateKey) {
            string2 = "DSA PRIVATE KEY";
            object5 = (DSAPrivateKey)object;
            object4 = object5.getParams();
            object3 = new ASN1EncodableVector();
            ((DEREncodableVector)object3).add(new DERInteger(0));
            ((DEREncodableVector)object3).add(new DERInteger(object4.getP()));
            ((DEREncodableVector)object3).add(new DERInteger(object4.getQ()));
            ((DEREncodableVector)object3).add(new DERInteger(object4.getG()));
            object2 = object5.getX();
            BigInteger bigInteger = object4.getG().modPow((BigInteger)object2, object4.getP());
            ((DEREncodableVector)object3).add(new DERInteger(bigInteger));
            ((DEREncodableVector)object3).add(new DERInteger((BigInteger)object2));
            byArray = new DERSequence((DEREncodableVector)object3).getEncoded();
        } else if (object instanceof PrivateKey && "ECDSA".equals(((PrivateKey)object).getAlgorithm())) {
            string2 = "EC PRIVATE KEY";
            object5 = PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(((PrivateKey)object).getEncoded()));
            byArray = ((PrivateKeyInfo)object5).getPrivateKey().getEncoded();
        }
        if (string2 == null || byArray == null) {
            throw new IllegalArgumentException("Object type not supported: " + object.getClass().getName());
        }
        object5 = Strings.toUpperCase(string);
        if (((String)object5).equals("DESEDE")) {
            object5 = "DES-EDE3-CBC";
        }
        int n = ((String)object5).startsWith("AES-") ? 16 : 8;
        object3 = new byte[n];
        secureRandom.nextBytes((byte[])object3);
        object2 = PEMUtilities.crypt(true, this.provider, byArray, cArray, (String)object5, (byte[])object3);
        this.writeHeader(string2);
        this.write("Proc-Type: 4,ENCRYPTED");
        this.newLine();
        this.write("DEK-Info: " + (String)object5 + ",");
        this.writeHexEncoded((byte[])object3);
        this.newLine();
        this.newLine();
        this.writeEncoded((byte[])object2);
        this.writeFooter(string2);
    }

    private void writeHeader(String string) throws IOException {
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
    }

    private void writeFooter(String string) throws IOException {
        this.write("-----END " + string + "-----");
        this.newLine();
    }
}

