/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.StringTokenizer;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMUtilities;
import org.bouncycastle.openssl.PasswordException;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class PEMReader
extends BufferedReader {
    private final PasswordFinder pFinder;
    private final String provider;

    public PEMReader(Reader reader) {
        this(reader, null, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder) {
        this(reader, passwordFinder, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder, String string) {
        super(reader);
        this.pFinder = passwordFinder;
        this.provider = string;
    }

    public Object readObject() throws IOException {
        String string;
        while ((string = this.readLine()) != null) {
            if (string.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                return this.readPublicKey("-----END PUBLIC KEY");
            }
            if (string.indexOf("-----BEGIN RSA PUBLIC KEY") != -1) {
                return this.readRSAPublicKey("-----END RSA PUBLIC KEY");
            }
            if (string.indexOf("-----BEGIN CERTIFICATE REQUEST") != -1) {
                return this.readCertificateRequest("-----END CERTIFICATE REQUEST");
            }
            if (string.indexOf("-----BEGIN NEW CERTIFICATE REQUEST") != -1) {
                return this.readCertificateRequest("-----END NEW CERTIFICATE REQUEST");
            }
            if (string.indexOf("-----BEGIN CERTIFICATE") != -1) {
                return this.readCertificate("-----END CERTIFICATE");
            }
            if (string.indexOf("-----BEGIN PKCS7") != -1) {
                return this.readPKCS7("-----END PKCS7");
            }
            if (string.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                return this.readCertificate("-----END X509 CERTIFICATE");
            }
            if (string.indexOf("-----BEGIN X509 CRL") != -1) {
                return this.readCRL("-----END X509 CRL");
            }
            if (string.indexOf("-----BEGIN ATTRIBUTE CERTIFICATE") != -1) {
                return this.readAttributeCertificate("-----END ATTRIBUTE CERTIFICATE");
            }
            if (string.indexOf("-----BEGIN RSA PRIVATE KEY") != -1) {
                try {
                    return this.readKeyPair("RSA", "-----END RSA PRIVATE KEY");
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new PEMException("problem creating RSA private key: " + exception.toString(), exception);
                }
            }
            if (string.indexOf("-----BEGIN DSA PRIVATE KEY") != -1) {
                try {
                    return this.readKeyPair("DSA", "-----END DSA PRIVATE KEY");
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new PEMException("problem creating DSA private key: " + exception.toString(), exception);
                }
            }
            if (string.indexOf("-----BEGIN EC PARAMETERS-----") != -1) {
                return this.readECParameters("-----END EC PARAMETERS-----");
            }
            if (string.indexOf("-----BEGIN EC PRIVATE KEY-----") == -1) continue;
            try {
                return this.readKeyPair("ECDSA", "-----END EC PRIVATE KEY-----");
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating ECDSA private key: " + exception.toString(), exception);
            }
        }
        return null;
    }

    private byte[] readBytes(String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = this.readLine()) != null) {
            if (string2.indexOf(string) != -1) break;
            stringBuffer.append(string2.trim());
        }
        if (string2 == null) {
            throw new IOException(string + " not found");
        }
        return Base64.decode(stringBuffer.toString());
    }

    private PublicKey readRSAPublicKey(String string) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(this.readBytes(string));
        DERObject dERObject = aSN1InputStream.readObject();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERObject;
        RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(aSN1Sequence);
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKeyStructure.getModulus(), rSAPublicKeyStructure.getPublicExponent());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", this.provider);
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new IOException("can't find provider " + this.provider);
        }
        catch (Exception exception) {
            throw new PEMException("problem extracting key: " + exception.toString(), exception);
        }
    }

    private PublicKey readPublicKey(String string) throws IOException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(this.readBytes(string));
        String[] stringArray = new String[]{"DSA", "RSA"};
        int n = 0;
        while (n < stringArray.length) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(stringArray[n], this.provider);
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                return publicKey;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException("can't find provider " + this.provider);
            }
            ++n;
        }
        return null;
    }

    private X509Certificate readCertificate(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readBytes(string));
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", this.provider);
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new PEMException("problem parsing cert: " + exception.toString(), exception);
        }
    }

    private X509CRL readCRL(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readBytes(string));
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", this.provider);
            return (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new PEMException("problem parsing cert: " + exception.toString(), exception);
        }
    }

    private PKCS10CertificationRequest readCertificateRequest(String string) throws IOException {
        try {
            return new PKCS10CertificationRequest(this.readBytes(string));
        }
        catch (Exception exception) {
            throw new PEMException("problem parsing certrequest: " + exception.toString(), exception);
        }
    }

    private X509AttributeCertificate readAttributeCertificate(String string) throws IOException {
        return new X509V2AttributeCertificate(this.readBytes(string));
    }

    private ContentInfo readPKCS7(String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((string2 = this.readLine()) != null) {
            if (string2.indexOf(string) != -1) break;
            string2 = string2.trim();
            stringBuffer.append(string2.trim());
            Base64.decode(stringBuffer.substring(0, stringBuffer.length() / 4 * 4), byteArrayOutputStream);
            stringBuffer.delete(0, stringBuffer.length() / 4 * 4);
        }
        if (stringBuffer.length() != 0) {
            throw new IOException("base64 data appears to be truncated");
        }
        if (string2 == null) {
            throw new IOException(string + " not found");
        }
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayOutputStream.toByteArray());
            return ContentInfo.getInstance(aSN1InputStream.readObject());
        }
        catch (Exception exception) {
            throw new PEMException("problem parsing PKCS7 object: " + exception.toString(), exception);
        }
    }

    private KeyPair readKeyPair(String string, String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string3 = this.readLine()) != null) {
            if (string3.startsWith("Proc-Type: 4,ENCRYPTED")) {
                bl = true;
                continue;
            }
            if (string3.startsWith("DEK-Info:")) {
                string4 = string3.substring(10);
                continue;
            }
            if (string3.indexOf(string2) != -1) break;
            stringBuffer.append(string3.trim());
        }
        byte[] byArray = Base64.decode(stringBuffer.toString());
        if (bl) {
            if (this.pFinder == null) {
                throw new PasswordException("No password finder specified, but a password is required");
            }
            object4 = this.pFinder.getPassword();
            if (object4 == null) {
                throw new PasswordException("Password is null, but a password is required");
            }
            object3 = new StringTokenizer(string4, ",");
            object2 = ((StringTokenizer)object3).nextToken();
            object = Hex.decode(((StringTokenizer)object3).nextToken());
            byArray = PEMUtilities.crypt(false, this.provider, byArray, object4, (String)object2, (byte[])object);
        }
        object2 = (ASN1Sequence)ASN1Object.fromByteArray(byArray);
        if (string.equals("RSA")) {
            object = (DERInteger)((ASN1Sequence)object2).getObjectAt(1);
            DERInteger dERInteger = (DERInteger)((ASN1Sequence)object2).getObjectAt(2);
            DERInteger dERInteger2 = (DERInteger)((ASN1Sequence)object2).getObjectAt(3);
            DERInteger dERInteger3 = (DERInteger)((ASN1Sequence)object2).getObjectAt(4);
            DERInteger dERInteger4 = (DERInteger)((ASN1Sequence)object2).getObjectAt(5);
            DERInteger dERInteger5 = (DERInteger)((ASN1Sequence)object2).getObjectAt(6);
            DERInteger dERInteger6 = (DERInteger)((ASN1Sequence)object2).getObjectAt(7);
            DERInteger dERInteger7 = (DERInteger)((ASN1Sequence)object2).getObjectAt(8);
            object4 = new RSAPublicKeySpec(((DERInteger)object).getValue(), dERInteger.getValue());
            object3 = new RSAPrivateCrtKeySpec(((DERInteger)object).getValue(), dERInteger.getValue(), dERInteger2.getValue(), dERInteger3.getValue(), dERInteger4.getValue(), dERInteger5.getValue(), dERInteger6.getValue(), dERInteger7.getValue());
        } else if (string.equals("ECDSA")) {
            object = new ECPrivateKeyStructure((ASN1Sequence)object2);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, ((ECPrivateKeyStructure)object).getParameters());
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, ((ASN1Encodable)object).getDERObject());
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, ((ECPrivateKeyStructure)object).getPublicKey().getBytes());
            object3 = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
            object4 = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
        } else {
            object = (DERInteger)((ASN1Sequence)object2).getObjectAt(1);
            DERInteger dERInteger = (DERInteger)((ASN1Sequence)object2).getObjectAt(2);
            DERInteger dERInteger8 = (DERInteger)((ASN1Sequence)object2).getObjectAt(3);
            DERInteger dERInteger9 = (DERInteger)((ASN1Sequence)object2).getObjectAt(4);
            DERInteger dERInteger10 = (DERInteger)((ASN1Sequence)object2).getObjectAt(5);
            object3 = new DSAPrivateKeySpec(dERInteger10.getValue(), ((DERInteger)object).getValue(), dERInteger.getValue(), dERInteger8.getValue());
            object4 = new DSAPublicKeySpec(dERInteger9.getValue(), ((DERInteger)object).getValue(), dERInteger.getValue(), dERInteger8.getValue());
        }
        object = KeyFactory.getInstance(string, this.provider);
        return new KeyPair(((KeyFactory)object).generatePublic((KeySpec)object4), ((KeyFactory)object).generatePrivate((KeySpec)object3));
    }

    private ECNamedCurveParameterSpec readECParameters(String string) throws IOException {
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)ASN1Object.fromByteArray(this.readBytes(string));
        return ECNamedCurveTable.getParameterSpec(dERObjectIdentifier.getId());
    }
}

