/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CRLEntryObject;
import org.bouncycastle.jce.provider.X509SignatureUtil;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class X509CRLObject
extends X509CRL {
    private CertificateList c;
    private String sigAlgName;
    private byte[] sigAlgParams;
    private boolean isIndirect;

    public X509CRLObject(CertificateList certificateList) throws CRLException {
        this.c = certificateList;
        try {
            this.sigAlgName = X509SignatureUtil.getSignatureName(certificateList.getSignatureAlgorithm());
            this.sigAlgParams = (byte[])(certificateList.getSignatureAlgorithm().getParameters() != null ? ((ASN1Encodable)certificateList.getSignatureAlgorithm().getParameters()).getDEREncoded() : null);
            this.isIndirect = this.isIndirectCRL();
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        return set != null && !set.isEmpty();
    }

    private Set getExtensionOIDs(boolean bl) {
        if (this.getVersion() == 2) {
            HashSet<String> hashSet = new HashSet<String>();
            X509Extensions x509Extensions = this.c.getTBSCertList().getExtensions();
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (bl != x509Extension.isCritical()) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.c.getTBSCertList().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            try {
                return x509Extension.getValue().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.c);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "BC");
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertList().getSignature())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        Signature signature = Signature.getInstance(this.getSigAlgName(), string);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        return this.c.getVersion();
    }

    public Principal getIssuerDN() {
        return new X509Principal(this.c.getIssuer());
    }

    public Date getThisUpdate() {
        return this.c.getThisUpdate().getDate();
    }

    public Date getNextUpdate() {
        if (this.c.getNextUpdate() != null) {
            return this.c.getNextUpdate().getDate();
        }
        return null;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            X509Principal x509Principal = (X509Principal)this.getIssuerDN();
            int n = 0;
            while (n < cRLEntryArray.length) {
                X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(cRLEntryArray[n], this.isIndirect, x509Principal);
                x509Principal = x509CRLEntryObject.getCertificateIssuer();
                if (x509CRLEntryObject.getSerialNumber().equals(bigInteger)) {
                    return x509CRLEntryObject;
                }
                ++n;
            }
        }
        return null;
    }

    public Set getRevokedCertificates() {
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            HashSet<X509CRLEntryObject> hashSet = new HashSet<X509CRLEntryObject>();
            X509Principal x509Principal = (X509Principal)this.getIssuerDN();
            int n = 0;
            while (n < cRLEntryArray.length) {
                X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(cRLEntryArray[n], this.isIndirect, x509Principal);
                hashSet.add(x509CRLEntryObject);
                x509Principal = x509CRLEntryObject.getCertificateIssuer();
                ++n;
            }
            return hashSet;
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.c.getTBSCertList().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getObjectId().getId();
    }

    public byte[] getSigAlgParams() {
        if (this.sigAlgParams != null) {
            byte[] byArray = new byte[this.sigAlgParams.length];
            System.arraycopy(this.sigAlgParams, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public String toString() {
        return "X.509 CRL";
    }

    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            int n = 0;
            while (n < cRLEntryArray.length) {
                if (cRLEntryArray[n].getUserCertificate().getValue().equals(bigInteger)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean isIndirectCRL() throws CRLException {
        byte[] byArray = this.getExtensionValue(X509Extensions.IssuingDistributionPoint.getId());
        boolean bl = false;
        try {
            if (byArray != null) {
                bl = IssuingDistributionPoint.getInstance(X509ExtensionUtil.fromExtensionValue(byArray)).isIndirectCRL();
            }
        }
        catch (IOException iOException) {
            throw new CRLException("Exception reading IssuingDistributionPoint" + iOException);
        }
        return bl;
    }
}

