/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathBuilderException;
import org.bouncycastle.jce.cert.CertPathBuilderResult;
import org.bouncycastle.jce.cert.CertPathBuilderSpi;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertPathValidator;
import org.bouncycastle.jce.cert.CertPathValidatorException;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.CertificateFactory;
import org.bouncycastle.jce.cert.PKIXBuilderParameters;
import org.bouncycastle.jce.cert.PKIXCertPathBuilderResult;
import org.bouncycastle.jce.cert.PKIXCertPathValidatorResult;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.cert.X509CertSelector;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        CertPathValidator certPathValidator;
        CertificateFactory certificateFactory;
        Collection collection;
        if (!(certPathParameters instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXBuilderParameters instance");
        }
        PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        CertPath certPath = null;
        GeneralSecurityException generalSecurityException = null;
        CertSelector certSelector = pKIXBuilderParameters.getTargetCertConstraints();
        if (certSelector == null) {
            throw new CertPathBuilderException("targetCertConstraints must be non-null for CertPath building");
        }
        try {
            collection = this.findCertificates(certSelector, pKIXBuilderParameters.getCertStores());
        }
        catch (CertStoreException certStoreException) {
            throw new CertPathBuilderException(certStoreException);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("no certificate found matching targetCertContraints");
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            certPathValidator = CertPathValidator.getInstance("PKIX", "BC");
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("exception creating support classes: " + exception);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = (X509Certificate)iterator.next();
            arrayList.clear();
            hashSet.clear();
            while (object != null) {
                Object object2;
                arrayList.add((X509Certificate)object);
                hashSet.add((X509Certificate)object);
                if (this.findTrustAnchor((X509Certificate)object, pKIXBuilderParameters.getTrustAnchors()) != null) {
                    try {
                        certPath = certificateFactory.generateCertPath(arrayList);
                        object2 = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXBuilderParameters);
                        return new PKIXCertPathBuilderResult(certPath, ((PKIXCertPathValidatorResult)object2).getTrustAnchor(), ((PKIXCertPathValidatorResult)object2).getPolicyTree(), ((PKIXCertPathValidatorResult)object2).getPublicKey());
                    }
                    catch (CertificateException certificateException) {
                        generalSecurityException = certificateException;
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        generalSecurityException = certPathValidatorException;
                    }
                    object = null;
                    continue;
                }
                try {
                    object2 = this.findIssuer((X509Certificate)object, pKIXBuilderParameters.getCertStores());
                    if (((Certificate)object2).equals(object)) {
                        object = null;
                        continue;
                    }
                    object = object2;
                    if (!hashSet.contains(object)) continue;
                    object = null;
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    generalSecurityException = certPathValidatorException;
                    object = null;
                }
            }
        }
        if (certPath != null) {
            throw new CertPathBuilderException("found certificate chain, but could not be validated", generalSecurityException);
        }
        throw new CertPathBuilderException("unable to find certificate chain");
    }

    /*
     * Unable to fully structure code
     */
    final TrustAnchor findTrustAnchor(X509Certificate var1_1, Set var2_2) throws CertPathBuilderException {
        var3_3 = var2_2.iterator();
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = new X509CertSelector();
        try {
            var7_7.setSubject(PrincipalUtil.getIssuerX509Principal(var1_1).getEncoded());
            if (true) ** GOTO lbl39
        }
        catch (Exception var8_8) {
            throw new CertPathBuilderException("can't get trust anchor principal", null);
        }
        do {
            block15: {
                if ((var4_4 = (TrustAnchor)var3_3.next()).getTrustedCert() != null) {
                    if (var7_7.match(var4_4.getTrustedCert())) {
                        var5_5 = var4_4.getTrustedCert().getPublicKey();
                    } else {
                        var4_4 = null;
                    }
                } else if (var4_4.getCAName() != null && var4_4.getCAPublicKey() != null) {
                    try {
                        var8_9 = PrincipalUtil.getIssuerX509Principal(var1_1);
                        var9_12 = new X509Principal(var4_4.getCAName());
                        if (var8_9.equals(var9_12)) {
                            var5_5 = var4_4.getCAPublicKey();
                            break block15;
                        }
                        var4_4 = null;
                    }
                    catch (Exception var8_10) {
                        var4_4 = null;
                    }
                } else {
                    var4_4 = null;
                }
            }
            if (var5_5 == null) continue;
            try {
                var1_1.verify(var5_5);
            }
            catch (Exception var8_11) {
                var6_6 = var8_11;
                var4_4 = null;
            }
lbl39:
            // 4 sources

        } while (var3_3.hasNext() && var4_4 == null);
        if (var4_4 == null && var6_6 != null) {
            throw new CertPathBuilderException("TrustAnchor found put certificate validation failed", var6_6);
        }
        return var4_4;
    }

    private Collection findCertificates(CertSelector certSelector, List list) throws CertStoreException {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            hashSet.addAll(certStore.getCertificates(certSelector));
        }
        return hashSet;
    }

    private X509Certificate findIssuer(X509Certificate x509Certificate, List list) throws CertPathValidatorException {
        Iterator iterator;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(PrincipalUtil.getIssuerX509Principal(x509Certificate).getEncoded());
        }
        catch (Exception exception2) {
            throw new CertPathValidatorException("Issuer not found", null, null, -1);
        }
        try {
            iterator = this.findCertificates(x509CertSelector, list).iterator();
        }
        catch (CertStoreException certStoreException) {
            throw new CertPathValidatorException(certStoreException);
        }
        X509Certificate x509Certificate2 = null;
        while (iterator.hasNext() && x509Certificate2 == null) {
            x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
            }
            catch (Exception exception3) {
                exception = exception3;
                x509Certificate2 = null;
            }
        }
        if (x509Certificate2 == null && exception == null) {
            throw new CertPathValidatorException("Issuer not found", null, null, -1);
        }
        if (x509Certificate2 == null && exception != null) {
            throw new CertPathValidatorException("issuer found but certificate validation failed", (Throwable)exception, null, -1);
        }
        return x509Certificate2;
    }
}

