/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.bouncycastle.jce.cert.CertificateFactory;

public abstract class CertPath
implements Serializable {
    private String type;

    protected CertPath(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator getEncodings();

    public boolean equals(Object object) {
        if (!(object instanceof CertPath)) {
            return false;
        }
        CertPath certPath = (CertPath)object;
        if (!this.getType().equals(certPath.getType())) {
            return false;
        }
        return this.getCertificates().equals(certPath.getCertificates());
    }

    public int hashCode() {
        return this.getType().hashCode() * 31 + this.getCertificates().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getCertificates();
        ListIterator listIterator = list.listIterator();
        stringBuffer.append('\n').append(this.getType()).append(" Cert Path: length = ").append(list.size()).append("\n[\n");
        while (listIterator.hasNext()) {
            stringBuffer.append("=========================================================Certificate ").append(listIterator.nextIndex()).append('\n');
            stringBuffer.append(listIterator.next()).append('\n');
            stringBuffer.append("========================================================Certificate end\n\n\n");
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract List getCertificates();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.getType(), this.getEncoded());
        }
        catch (CertificateException certificateException) {
            throw new NotSerializableException(" java.security.cert.CertPath: " + this.getType());
        }
    }

    protected static class CertPathRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected CertPathRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertPath(byteArrayInputStream);
            }
            catch (CertificateException certificateException) {
                throw new NotSerializableException(" java.security.cert.CertPath: " + this.type);
            }
        }
    }
}

