/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.crypto.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private final int[][][] M = new int[16][256][];

    public void init(byte[] byArray) {
        this.M[0][0] = new int[4];
        this.M[0][128] = GCMUtil.asInts(byArray);
        int n = 64;
        while (n >= 1) {
            int[] nArray = new int[4];
            System.arraycopy(this.M[0][n + n], 0, nArray, 0, 4);
            GCMUtil.multiplyP(nArray);
            this.M[0][n] = nArray;
            n >>= 1;
        }
        int n2 = 0;
        block1: while (true) {
            int[] nArray;
            int n3;
            int n4 = 2;
            while (n4 < 256) {
                n3 = 1;
                while (n3 < n4) {
                    nArray = new int[4];
                    System.arraycopy(this.M[n2][n4], 0, nArray, 0, 4);
                    GCMUtil.xor(nArray, this.M[n2][n3]);
                    this.M[n2][n4 + n3] = nArray;
                    ++n3;
                }
                n4 += n4;
            }
            if (++n2 == 16) {
                return;
            }
            this.M[n2][0] = new int[4];
            n3 = 128;
            while (true) {
                if (n3 <= 0) continue block1;
                nArray = new int[4];
                System.arraycopy(this.M[n2 - 1][n3], 0, nArray, 0, 4);
                GCMUtil.multiplyP8(nArray);
                this.M[n2][n3] = nArray;
                n3 >>= 1;
            }
            break;
        }
    }

    public void multiplyH(byte[] byArray) {
        int[] nArray = new int[4];
        int n = 15;
        while (n >= 0) {
            int[] nArray2 = this.M[n][byArray[n] & 0xFF];
            nArray[0] = nArray[0] ^ nArray2[0];
            nArray[1] = nArray[1] ^ nArray2[1];
            nArray[2] = nArray[2] ^ nArray2[2];
            nArray[3] = nArray[3] ^ nArray2[3];
            --n;
        }
        Pack.intToBigEndian(nArray[0], byArray, 0);
        Pack.intToBigEndian(nArray[1], byArray, 4);
        Pack.intToBigEndian(nArray[2], byArray, 8);
        Pack.intToBigEndian(nArray[3], byArray, 12);
    }
}

