/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class BasicGCMMultiplier
implements GCMMultiplier {
    private byte[] H;

    public void init(byte[] byArray) {
        this.H = Arrays.clone(byArray);
    }

    public void multiplyH(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 16) {
            byte by = this.H[n];
            int n2 = 7;
            while (n2 >= 0) {
                if ((by & 1 << n2) != 0) {
                    GCMUtil.xor(byArray2, byArray);
                }
                boolean bl = (byArray[15] & 1) != 0;
                GCMUtil.shiftRight(byArray);
                if (bl) {
                    byArray[0] = (byte)(byArray[0] ^ 0xFFFFFFE1);
                }
                --n2;
            }
            ++n;
        }
        System.arraycopy(byArray2, 0, byArray, 0, 16);
    }
}

