/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.OriginatorId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import org.bouncycastle.jce.spec.MQVPublicKeySpec;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString encryptedKey;

    public KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, InputStream inputStream) {
        this(keyAgreeRecipientInfo, algorithmIdentifier, null, null, inputStream);
    }

    public KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, InputStream inputStream) {
        this(keyAgreeRecipientInfo, algorithmIdentifier, algorithmIdentifier2, null, inputStream);
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3, InputStream inputStream) {
        super(algorithmIdentifier, algorithmIdentifier2, algorithmIdentifier3, keyAgreeRecipientInfo.getKeyEncryptionAlgorithm(), inputStream);
        this.info = keyAgreeRecipientInfo;
        this.rid = new RecipientId();
        try {
            ASN1Sequence aSN1Sequence = this.info.getRecipientEncryptedKeys();
            RecipientEncryptedKey recipientEncryptedKey = RecipientEncryptedKey.getInstance(aSN1Sequence.getObjectAt(0));
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = recipientEncryptedKey.getIdentifier();
            IssuerAndSerialNumber issuerAndSerialNumber = keyAgreeRecipientIdentifier.getIssuerAndSerialNumber();
            if (issuerAndSerialNumber != null) {
                this.rid.setIssuer(issuerAndSerialNumber.getName().getEncoded());
                this.rid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier recipientKeyIdentifier = keyAgreeRecipientIdentifier.getRKeyID();
                this.rid.setSubjectKeyIdentifier(recipientKeyIdentifier.getSubjectKeyIdentifier().getOctets());
            }
            this.encryptedKey = recipientEncryptedKey.getEncryptedKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid rid in KeyAgreeRecipientInformation");
        }
    }

    private PublicKey getSenderPublicKey(Key key, OriginatorIdentifierOrKey originatorIdentifierOrKey, Provider provider) throws CMSException, GeneralSecurityException, IOException {
        OriginatorPublicKey originatorPublicKey = originatorIdentifierOrKey.getOriginatorKey();
        if (originatorPublicKey != null) {
            return this.getPublicKeyFromOriginatorPublicKey(key, originatorPublicKey, provider);
        }
        OriginatorId originatorId = new OriginatorId();
        IssuerAndSerialNumber issuerAndSerialNumber = originatorIdentifierOrKey.getIssuerAndSerialNumber();
        if (issuerAndSerialNumber != null) {
            originatorId.setIssuer(issuerAndSerialNumber.getName().getEncoded());
            originatorId.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier subjectKeyIdentifier = originatorIdentifierOrKey.getSubjectKeyIdentifier();
            originatorId.setSubjectKeyIdentifier(subjectKeyIdentifier.getKeyIdentifier());
        }
        return this.getPublicKeyFromOriginatorId(originatorId, provider);
    }

    private PublicKey getPublicKeyFromOriginatorPublicKey(Key key, OriginatorPublicKey originatorPublicKey, Provider provider) throws CMSException, GeneralSecurityException, IOException {
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(key.getEncoded()));
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(privateKeyInfo.getAlgorithmId(), originatorPublicKey.getPublicKey().getBytes());
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance(this.keyEncAlg.getObjectId().getId(), provider.getName());
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    private PublicKey getPublicKeyFromOriginatorId(OriginatorId originatorId, Provider provider) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    private SecretKey calculateAgreedWrapKey(String string, PublicKey publicKey, PrivateKey privateKey, Provider provider) throws CMSException, GeneralSecurityException, IOException {
        Object object;
        String string2 = this.keyEncAlg.getObjectId().getId();
        if (string2.equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            object = this.info.getUserKeyingMaterial().getOctets();
            MQVuserKeyingMaterial mQVuserKeyingMaterial = MQVuserKeyingMaterial.getInstance(ASN1Object.fromByteArray((byte[])object));
            PublicKey publicKey2 = this.getPublicKeyFromOriginatorPublicKey(privateKey, mQVuserKeyingMaterial.getEphemeralPublicKey(), provider);
            publicKey = new MQVPublicKeySpec(publicKey, publicKey2);
            privateKey = new MQVPrivateKeySpec(privateKey, privateKey);
        }
        object = KeyAgreement.getInstance(string2, provider);
        ((KeyAgreement)object).init(privateKey);
        ((KeyAgreement)object).doPhase(publicKey, true);
        return ((KeyAgreement)object).generateSecret(string);
    }

    private Key unwrapSessionKey(String string, SecretKey secretKey, Provider provider) throws GeneralSecurityException {
        AlgorithmIdentifier algorithmIdentifier = this.getActiveAlgID();
        String string2 = algorithmIdentifier.getObjectId().getId();
        byte[] byArray = this.encryptedKey.getOctets();
        Cipher cipher = Cipher.getInstance(string, provider);
        cipher.init(4, secretKey);
        return cipher.unwrap(byArray, string2, 3);
    }

    protected Key getSessionKey(Key key, Provider provider) throws CMSException {
        try {
            String string = DERObjectIdentifier.getInstance(ASN1Sequence.getInstance(this.keyEncAlg.getParameters()).getObjectAt(0)).getId();
            PublicKey publicKey = this.getSenderPublicKey(key, this.info.getOriginator(), provider);
            SecretKey secretKey = this.calculateAgreedWrapKey(string, publicKey, (PrivateKey)key, provider);
            return this.unwrapSessionKey(string, secretKey, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CMSException("originator key spec invalid.", invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (Exception exception) {
            throw new CMSException("originator key invalid.", exception);
        }
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        Key key2 = this.getSessionKey(key, provider);
        return this.getContentFromSessionKey(key2, provider);
    }
}

