/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSPBEKey;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.KEKRecipientInfoGenerator;
import org.bouncycastle.cms.KeyAgreeRecipientInfoGenerator;
import org.bouncycastle.cms.KeyTransRecipientInfoGenerator;
import org.bouncycastle.cms.PasswordRecipientInfoGenerator;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import org.bouncycastle.jce.spec.MQVPublicKeySpec;

public class CMSEnvelopedGenerator {
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String CAMELLIA128_CBC = NTTObjectIdentifiers.id_camellia128_cbc.getId();
    public static final String CAMELLIA192_CBC = NTTObjectIdentifiers.id_camellia192_cbc.getId();
    public static final String CAMELLIA256_CBC = NTTObjectIdentifiers.id_camellia256_cbc.getId();
    public static final String SEED_CBC = KISAObjectIdentifiers.id_seedCBC.getId();
    public static final String DES_EDE3_WRAP = PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId();
    public static final String AES128_WRAP = NISTObjectIdentifiers.id_aes128_wrap.getId();
    public static final String AES192_WRAP = NISTObjectIdentifiers.id_aes192_wrap.getId();
    public static final String AES256_WRAP = NISTObjectIdentifiers.id_aes256_wrap.getId();
    public static final String CAMELLIA128_WRAP = NTTObjectIdentifiers.id_camellia128_wrap.getId();
    public static final String CAMELLIA192_WRAP = NTTObjectIdentifiers.id_camellia192_wrap.getId();
    public static final String CAMELLIA256_WRAP = NTTObjectIdentifiers.id_camellia256_wrap.getId();
    public static final String SEED_WRAP = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId();
    public static final String ECDH_SHA1KDF = X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme.getId();
    public static final String ECMQV_SHA1KDF = X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme.getId();
    final List recipientInfoGenerators = new ArrayList();
    final SecureRandom rand;

    public CMSEnvelopedGenerator() {
        this(new SecureRandom());
    }

    public CMSEnvelopedGenerator(SecureRandom secureRandom) {
        this.rand = secureRandom;
    }

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        KeyTransRecipientInfoGenerator keyTransRecipientInfoGenerator = new KeyTransRecipientInfoGenerator();
        keyTransRecipientInfoGenerator.setRecipientCert(x509Certificate);
        this.recipientInfoGenerators.add(keyTransRecipientInfoGenerator);
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        KeyTransRecipientInfoGenerator keyTransRecipientInfoGenerator = new KeyTransRecipientInfoGenerator();
        keyTransRecipientInfoGenerator.setRecipientPublicKey(publicKey);
        keyTransRecipientInfoGenerator.setSubjectKeyIdentifier(new DEROctetString(byArray));
        this.recipientInfoGenerators.add(keyTransRecipientInfoGenerator);
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) {
        KEKRecipientInfoGenerator kEKRecipientInfoGenerator = new KEKRecipientInfoGenerator();
        kEKRecipientInfoGenerator.setKEKIdentifier(new KEKIdentifier(byArray, null, null));
        kEKRecipientInfoGenerator.setWrapKey(secretKey);
        this.recipientInfoGenerators.add(kEKRecipientInfoGenerator);
    }

    public void addPasswordRecipient(CMSPBEKey cMSPBEKey, String string) {
        PBKDF2Params pBKDF2Params = new PBKDF2Params(cMSPBEKey.getSalt(), cMSPBEKey.getIterationCount());
        PasswordRecipientInfoGenerator passwordRecipientInfoGenerator = new PasswordRecipientInfoGenerator();
        passwordRecipientInfoGenerator.setDerivationAlg(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, pBKDF2Params));
        passwordRecipientInfoGenerator.setWrapKey(new SecretKeySpec(cMSPBEKey.getEncoded(string), string));
        this.recipientInfoGenerators.add(passwordRecipientInfoGenerator);
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipient(string, privateKey, publicKey, x509Certificate, string2, CMSUtils.getProvider(string3));
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        Object object;
        Object object2;
        Object object3;
        OriginatorIdentifierOrKey originatorIdentifierOrKey;
        try {
            originatorIdentifierOrKey = new OriginatorIdentifierOrKey(CMSEnvelopedGenerator.createOriginatorPublicKey(publicKey));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("cannot extract originator public key: " + iOException);
        }
        DEROctetString dEROctetString = null;
        PublicKey publicKey2 = x509Certificate.getPublicKey();
        if (string.equals(ECMQV_SHA1KDF)) {
            try {
                object3 = ((ECPublicKey)publicKey).getParams();
                object2 = KeyPairGenerator.getInstance(string, provider.getName());
                ((KeyPairGenerator)object2).initialize((AlgorithmParameterSpec)object3, this.rand);
                object = ((KeyPairGenerator)object2).generateKeyPair();
                dEROctetString = new DEROctetString(new MQVuserKeyingMaterial(CMSEnvelopedGenerator.createOriginatorPublicKey(((KeyPair)object).getPublic()), null));
                publicKey2 = new MQVPublicKeySpec(publicKey2, publicKey2);
                privateKey = new MQVPrivateKeySpec(privateKey, ((KeyPair)object).getPrivate(), ((KeyPair)object).getPublic());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException("cannot determine MQV ephemeral key pair parameters from public key: " + invalidAlgorithmParameterException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InvalidKeyException("cannot extract MQV ephemeral public key: " + noSuchProviderException);
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("cannot extract MQV ephemeral public key: " + iOException);
            }
        }
        object3 = KeyAgreement.getInstance(string, provider);
        ((KeyAgreement)object3).init((Key)privateKey, this.rand);
        ((KeyAgreement)object3).doPhase(publicKey2, true);
        object2 = ((KeyAgreement)object3).generateSecret(string2);
        object = new KeyAgreeRecipientInfoGenerator();
        ((KeyAgreeRecipientInfoGenerator)object).setAlgorithmOID(new DERObjectIdentifier(string));
        ((KeyAgreeRecipientInfoGenerator)object).setOriginator(originatorIdentifierOrKey);
        ((KeyAgreeRecipientInfoGenerator)object).setRecipientCert(x509Certificate);
        ((KeyAgreeRecipientInfoGenerator)object).setUKM(dEROctetString);
        ((KeyAgreeRecipientInfoGenerator)object).setWrapKey((SecretKey)object2);
        ((KeyAgreeRecipientInfoGenerator)object).setWrapAlgorithmOID(new DERObjectIdentifier(string2));
        this.recipientInfoGenerators.add(object);
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String string, AlgorithmParameters algorithmParameters) throws IOException {
        ASN1Object aSN1Object = algorithmParameters != null ? ASN1Object.fromByteArray(algorithmParameters.getEncoded("ASN.1")) : DERNull.INSTANCE;
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), aSN1Object);
    }

    protected AlgorithmParameters generateParameters(String string, SecretKey secretKey, Provider provider) throws CMSException {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(string, provider.getName());
            if (string.equals(RC2_CBC)) {
                byte[] byArray = new byte[8];
                this.rand.nextBytes(byArray);
                try {
                    algorithmParameterGenerator.init(new RC2ParameterSpec(secretKey.getEncoded().length * 8, byArray), this.rand);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new CMSException("parameters generation error: " + invalidAlgorithmParameterException, invalidAlgorithmParameterException);
                }
            }
            return algorithmParameterGenerator.generateParameters();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static OriginatorPublicKey createOriginatorPublicKey(PublicKey publicKey) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(publicKey.getEncoded()));
        return new OriginatorPublicKey(new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithmId().getObjectId(), DERNull.INSTANCE), subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }
}

