/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.StringTokenizer;
import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.IPAddress;

public class GeneralName
extends ASN1Encodable
implements ASN1Choice {
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int uniformResourceIdentifier = 6;
    public static final int iPAddress = 7;
    public static final int registeredID = 8;
    DEREncodable obj;
    int tag;

    public GeneralName(X509Name x509Name) {
        this.obj = x509Name;
        this.tag = 4;
    }

    public GeneralName(DERObject dERObject, int n) {
        this.obj = dERObject;
        this.tag = n;
    }

    public GeneralName(int n, ASN1Encodable aSN1Encodable) {
        this.obj = aSN1Encodable;
        this.tag = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralName(int n, String string) {
        this.tag = n;
        if (n == 1 || n == 2 || n == 6) {
            this.obj = new DERIA5String(string);
            return;
        } else if (n == 8) {
            this.obj = new DERObjectIdentifier(string);
            return;
        } else if (n == 4) {
            this.obj = new X509Name(string);
            return;
        } else {
            if (n != 7) throw new IllegalArgumentException("can't process String for tag: " + n);
            byte[] byArray = this.toGeneralNameEncoding(string);
            if (byArray == null) throw new IllegalArgumentException("IP Address is invalid");
            this.obj = new DEROctetString(byArray);
        }
    }

    public static GeneralName getInstance(Object object) {
        if (object == null || object instanceof GeneralName) {
            return (GeneralName)object;
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            int n = aSN1TaggedObject.getTagNo();
            switch (n) {
                case 0: {
                    return new GeneralName(n, ASN1Sequence.getInstance(aSN1TaggedObject, false));
                }
                case 1: {
                    return new GeneralName(n, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 2: {
                    return new GeneralName(n, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + n);
                }
                case 4: {
                    return new GeneralName(n, X509Name.getInstance(aSN1TaggedObject, true));
                }
                case 5: {
                    return new GeneralName(n, ASN1Sequence.getInstance(aSN1TaggedObject, false));
                }
                case 6: {
                    return new GeneralName(n, DERIA5String.getInstance(aSN1TaggedObject, false));
                }
                case 7: {
                    return new GeneralName(n, ASN1OctetString.getInstance(aSN1TaggedObject, false));
                }
                case 8: {
                    return new GeneralName(n, DERObjectIdentifier.getInstance(aSN1TaggedObject, false));
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static GeneralName getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(aSN1TaggedObject, true));
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tag);
        stringBuffer.append(": ");
        switch (this.tag) {
            case 1: 
            case 2: 
            case 6: {
                stringBuffer.append(DERIA5String.getInstance(this.obj).getString());
                break;
            }
            case 4: {
                stringBuffer.append(X509Name.getInstance(this.obj).toString());
                break;
            }
            default: {
                stringBuffer.append(this.obj.toString());
            }
        }
        return stringBuffer.toString();
    }

    private byte[] toGeneralNameEncoding(String string) {
        if (IPAddress.isValidIPv6WithNetmask(string) || IPAddress.isValidIPv6(string)) {
            int n = string.indexOf(47);
            if (n < 0) {
                byte[] byArray = new byte[16];
                int[] nArray = this.parseIPv6(string);
                this.copyInts(nArray, byArray, 0);
                return byArray;
            }
            byte[] byArray = new byte[32];
            int[] nArray = this.parseIPv6(string.substring(0, n));
            this.copyInts(nArray, byArray, 0);
            String string2 = string.substring(n + 1);
            nArray = string2.indexOf(58) > 0 ? this.parseIPv6(string2) : this.parseMask(string2);
            this.copyInts(nArray, byArray, 16);
            return byArray;
        }
        if (IPAddress.isValidIPv4WithNetmask(string) || IPAddress.isValidIPv4(string)) {
            int n = string.indexOf(47);
            if (n < 0) {
                byte[] byArray = new byte[4];
                this.parseIPv4(string, byArray, 0);
                return byArray;
            }
            byte[] byArray = new byte[8];
            this.parseIPv4(string.substring(0, n), byArray, 0);
            String string3 = string.substring(n + 1);
            if (string3.indexOf(46) > 0) {
                this.parseIPv4(string3, byArray, 4);
            } else {
                this.parseIPv4Mask(string3, byArray, 4);
            }
            return byArray;
        }
        return null;
    }

    private void parseIPv4Mask(String string, byte[] byArray, int n) {
        int n2 = Integer.parseInt(string);
        int n3 = 0;
        while (n3 != n2) {
            int n4 = n3 / 8 + n;
            byArray[n4] = (byte)(byArray[n4] | 1 << n3 % 8);
            ++n3;
        }
    }

    private void parseIPv4(String string, byte[] byArray, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "./");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            byArray[n + n2++] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        }
    }

    private int[] parseMask(String string) {
        int[] nArray = new int[8];
        int n = Integer.parseInt(string);
        int n2 = 0;
        while (n2 != n) {
            int n3 = n2 / 16;
            nArray[n3] = nArray[n3] | 1 << n2 % 16;
            ++n2;
        }
        return nArray;
    }

    private void copyInts(int[] nArray, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 != nArray.length) {
            byArray[n2 * 2 + n] = (byte)(nArray[n2] >> 8);
            byArray[n2 * 2 + 1 + n] = (byte)nArray[n2];
            ++n2;
        }
    }

    private int[] parseIPv6(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
        int n = 0;
        int[] nArray = new int[8];
        if (string.charAt(0) == ':' && string.charAt(1) == ':') {
            stringTokenizer.nextToken();
        }
        int n2 = -1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(":")) {
                n2 = n;
                nArray[n++] = 0;
                continue;
            }
            if (string2.indexOf(46) < 0) {
                nArray[n++] = Integer.parseInt(string2, 16);
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringTokenizer.nextToken();
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
            nArray[n++] = Integer.parseInt(stringTokenizer2.nextToken()) << 8 | Integer.parseInt(stringTokenizer2.nextToken());
            nArray[n++] = Integer.parseInt(stringTokenizer2.nextToken()) << 8 | Integer.parseInt(stringTokenizer2.nextToken());
        }
        if (n != nArray.length) {
            System.arraycopy(nArray, n2, nArray, nArray.length - (n - n2), n - n2);
            int n3 = n2;
            while (n3 != nArray.length - (n - n2)) {
                nArray[n3] = 0;
                ++n3;
            }
        }
        return nArray;
    }

    public DERObject toASN1Object() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

