/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.esf;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;

public class SigPolicyQualifiers
extends ASN1Encodable {
    ASN1Sequence qualifiers;

    public static SigPolicyQualifiers getInstance(Object object) {
        if (object instanceof SigPolicyQualifiers) {
            return (SigPolicyQualifiers)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SigPolicyQualifiers((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in 'SigPolicyQualifiers' factory: " + object.getClass().getName() + ".");
    }

    public SigPolicyQualifiers(ASN1Sequence aSN1Sequence) {
        this.qualifiers = aSN1Sequence;
    }

    public SigPolicyQualifiers(SigPolicyQualifierInfo[] sigPolicyQualifierInfoArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n < sigPolicyQualifierInfoArray.length) {
            aSN1EncodableVector.add(sigPolicyQualifierInfoArray[n]);
            ++n;
        }
        this.qualifiers = new DERSequence(aSN1EncodableVector);
    }

    public int size() {
        return this.qualifiers.size();
    }

    public SigPolicyQualifierInfo getStringAt(int n) {
        return SigPolicyQualifierInfo.getInstance(this.qualifiers.getObjectAt(n));
    }

    public DERObject toASN1Object() {
        return this.qualifiers;
    }
}

