/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.util.Arrays;

public class DERApplicationSpecific
extends ASN1Object {
    private final boolean isConstructed;
    private final int tag;
    private final byte[] octets;

    DERApplicationSpecific(boolean bl, int n, byte[] byArray) {
        this.isConstructed = bl;
        this.tag = n;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n, byte[] byArray) {
        this(false, n, byArray);
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this(true, n, dEREncodable);
    }

    public DERApplicationSpecific(boolean bl, int n, DEREncodable dEREncodable) throws IOException {
        byte[] byArray = dEREncodable.getDERObject().getDEREncoded();
        this.isConstructed = bl;
        this.tag = n;
        if (bl) {
            this.octets = byArray;
        } else {
            int n2 = this.getLengthOfLength(byArray);
            byte[] byArray2 = new byte[byArray.length - n2];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            this.octets = byArray2;
        }
    }

    public DERApplicationSpecific(int n, ASN1EncodableVector aSN1EncodableVector) {
        this.tag = n;
        this.isConstructed = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 != aSN1EncodableVector.size()) {
            try {
                byteArrayOutputStream.write(((ASN1Encodable)aSN1EncodableVector.get(n2)).getEncoded());
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("malformed object: " + iOException, iOException);
            }
            ++n2;
        }
        this.octets = byteArrayOutputStream.toByteArray();
    }

    private int getLengthOfLength(byte[] byArray) {
        int n = 2;
        while ((byArray[n - 1] & 0x80) != 0) {
            ++n;
        }
        return n;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public DERObject getObject(int n) throws IOException {
        if (n >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = this.replaceTagNumber(n, byArray);
        if ((byArray[0] & 0x20) != 0) {
            byArray2[0] = (byte)(byArray2[0] | 0x20);
        }
        return new ASN1InputStream(byArray2).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        int n = 64;
        if (this.isConstructed) {
            n |= 0x20;
        }
        dEROutputStream.writeEncoded(n, this.tag, this.octets);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        return this.isConstructed == dERApplicationSpecific.isConstructed && this.tag == dERApplicationSpecific.tag && Arrays.areEqual(this.octets, dERApplicationSpecific.octets);
    }

    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] replaceTagNumber(int var1_1, byte[] var2_2) throws IOException {
        block1: {
            var3_3 = var2_2[0] & 31;
            var4_4 = 1;
            if (var3_3 != 31) break block1;
            var3_3 = 0;
            if (((var5_5 = var2_2[var4_4++] & 255) & 127) != 0) ** GOTO lbl10
            throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
lbl-1000:
            // 1 sources

            {
                var3_3 |= var5_5 & 127;
                var3_3 <<= 7;
                var5_5 = var2_2[var4_4++] & 255;
lbl10:
                // 2 sources

                ** while (var5_5 >= 0 && (var5_5 & 128) != 0)
            }
lbl11:
            // 1 sources

            var3_3 |= var5_5 & 127;
        }
        var5_6 = new byte[var2_2.length - var4_4 + 1];
        System.arraycopy(var2_2, var4_4, var5_6, 1, var5_6.length - 1);
        var5_6[0] = (byte)var1_1;
        return var5_6;
    }
}

