/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.sobre;

import java.io.IOException;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class SignedAndEnveloped {
    private DERSequence secuencia = null;
    private DERInteger version = null;
    private ASN1Set recipienInfos = null;
    private ASN1Set digestAlgorithms = null;
    private EncryptedContentInfo encryptedContenInfo = null;
    private ASN1Set certificates = null;
    private ASN1Set signerInfos = null;

    private void ver_SignedAndEnveloped() {
    }

    public SignedAndEnveloped(DERInteger dERInteger, ASN1Set aSN1Set, ASN1Set aSN1Set2, EncryptedContentInfo encryptedContentInfo, ASN1Set aSN1Set3, ASN1Set aSN1Set4) {
        this.version = dERInteger;
        this.recipienInfos = aSN1Set;
        this.digestAlgorithms = aSN1Set2;
        this.encryptedContenInfo = encryptedContentInfo;
        this.certificates = aSN1Set3;
        this.signerInfos = aSN1Set4;
    }

    public SignedAndEnveloped(DEREncodable dEREncodable) throws IOException, SgiCriptoException {
        this.secuencia = (DERSequence)dEREncodable;
        this.version = (DERInteger)this.secuencia.getObjectAt(0);
        this.recipienInfos = (ASN1Set)this.secuencia.getObjectAt(1);
        this.encryptedContenInfo = new EncryptedContentInfo((DERSequence)this.secuencia.getObjectAt(3));
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.secuencia.getObjectAt(4);
        this.certificates = ASN1Set.getInstance(aSN1TaggedObject, false);
        if (this.secuencia.size() == 7) {
            this.signerInfos = (ASN1Set)this.secuencia.getObjectAt(6);
        } else if (this.secuencia.size() == 6) {
            this.signerInfos = (ASN1Set)this.secuencia.getObjectAt(5);
        } else {
            throw new SgiCriptoException("Sobre mal formado.", 7000);
        }
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public ASN1Set getCertificados() {
        return this.certificates;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    public ASN1EncodableVector getRecipientInfos() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n < this.recipienInfos.size()) {
            RecipientInfo recipientInfo = new RecipientInfo(this.recipienInfos.getObjectAt(n).getDERObject());
            aSN1EncodableVector.add(recipientInfo);
            ++n;
        }
        return aSN1EncodableVector;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContenInfo;
    }

    public byte[] getEncoded() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(this.version);
        aSN1EncodableVector2.add(this.recipienInfos);
        aSN1EncodableVector2.add(this.digestAlgorithms);
        aSN1EncodableVector2.add(this.encryptedContenInfo);
        ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
        int n = 0;
        while (n < this.certificates.size()) {
            aSN1EncodableVector3.add(this.certificates.getObjectAt(n));
            ++n;
        }
        DERSequence dERSequence = new DERSequence(aSN1EncodableVector3);
        aSN1EncodableVector2.add(new DERTaggedObject(false, 0, dERSequence));
        aSN1EncodableVector2.add(this.signerInfos);
        aSN1EncodableVector.add(PKCSObjectIdentifiers.signedAndEnvelopedData);
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, new DERSequence(aSN1EncodableVector2)));
        this.secuencia = new DERSequence(aSN1EncodableVector);
        return this.secuencia.getDEREncoded();
    }
}

