/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.sobre;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import mx.gob.sat.sgi.SgiCripto.AlgSimetrico;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.SgiLlavePrivada;
import mx.gob.sat.sgi.SgiCripto.sobre.CMSEnvelopedAndSignedDataStreamGenerator;
import mx.gob.sat.sgi.SgiCripto.sobre.Ensobretado;
import mx.gob.sat.sgi.SgiCripto.sobre.FirmaSimetrica;
import mx.gob.sat.sgi.SgiCripto.sobre.Firmado;
import mx.gob.sat.sgi.SgiCripto.sobre.FirmadoyEnsobretadoBis;
import mx.gob.sat.sgi.SgiCripto.sobre.SignedAndEnveloped;
import mx.gob.sat.sgi.SgiCripto.sobre.Util;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.util.io.Streams;

public class FirmadoyEnsobretado
extends Firmado {
    private SignedAndEnveloped sae = null;
    private Ensobretado sobre = null;

    private void ver_FirmadoyEnsobretado() {
    }

    public FirmadoyEnsobretado() {
        super(new FirmaSimetrica());
    }

    public boolean inicia(DEREncodable dEREncodable) throws IOException, SgiCriptoException {
        this.sae = new SignedAndEnveloped(dEREncodable);
        this.sobre = new Ensobretado();
        return true;
    }

    public boolean procesa(OutputStream outputStream, X509CertificateStructure x509CertificateStructure, X509CertificateStructure x509CertificateStructure2, SgiLlavePrivada sgiLlavePrivada) throws IOException, SgiCriptoException {
        Object object;
        X509CertificateStructure x509CertificateStructure3 = null;
        if (x509CertificateStructure != null) {
            x509CertificateStructure3 = x509CertificateStructure;
        } else {
            object = this.extraerCertificados(this.sae.getCertificados());
            if (((X509CertificateStructure[])object).length > 0) {
                x509CertificateStructure3 = object[0];
            } else {
                throw new SgiCriptoException("El sobre no contiene certificados.", 6000);
            }
        }
        object = new IssuerAndSerialNumber(x509CertificateStructure3.getIssuer(), x509CertificateStructure3.getSerialNumber());
        SignerInfo[] signerInfoArray = this.extraerSigners(this.sae.getSignerInfos());
        int n = 0;
        while (n < signerInfoArray.length) {
            EncryptedContentInfo encryptedContentInfo;
            ASN1EncodableVector aSN1EncodableVector;
            Key key;
            if (signerInfoArray[n].getIssuerAndSerialNumber().equals(object) && (key = this.sobre.getLlaveSimetrica(x509CertificateStructure2, sgiLlavePrivada, aSN1EncodableVector = this.sae.getRecipientInfos(), encryptedContentInfo = this.sae.getEncryptedContentInfo())) != null && encryptedContentInfo != null) {
                this.data_bytes = this.sobre.getContent(key, encryptedContentInfo);
                ((FirmaSimetrica)this.delegado).setParametros(key, encryptedContentInfo);
                if (this.procesaFirma(this.data_bytes, x509CertificateStructure3, signerInfoArray[n])) {
                    outputStream.write(this.data_bytes);
                    return true;
                }
                return false;
            }
            ++n;
        }
        return false;
    }

    public boolean generaFirmagdoyEnsobretadoMod(SgiCertificado[] sgiCertificadoArray, SgiCertificado[] sgiCertificadoArray2, SgiLlavePrivada[] sgiLlavePrivadaArray, int n, InputStream inputStream, int[] nArray, OutputStream outputStream) throws SgiCriptoException {
        try {
            this.setGenerar(true);
            ASN1EncodableVector aSN1EncodableVector = Util.algoritmos(nArray);
            ASN1EncodableVector aSN1EncodableVector2 = Util.certificados(sgiCertificadoArray2);
            ASN1EncodableVector aSN1EncodableVector3 = Util.certificados(sgiCertificadoArray);
            ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
            int n2 = 0;
            while (n2 < aSN1EncodableVector3.size()) {
                aSN1EncodableVector4.add(aSN1EncodableVector3.get(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < aSN1EncodableVector2.size()) {
                aSN1EncodableVector4.add(aSN1EncodableVector2.get(n3));
                ++n3;
            }
            Firmado firmado = new Firmado();
            CMSSignedData cMSSignedData = firmado.getSignedData(sgiCertificadoArray2, sgiLlavePrivadaArray, nArray, inputStream);
            ContentInfo contentInfo = cMSSignedData.getContentInfo();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(contentInfo.getContent());
            Ensobretado ensobretado = new Ensobretado();
            CMSEnvelopedData cMSEnvelopedData = ensobretado.getEnvelopedData(sgiCertificadoArray, n, inputStream);
            ContentInfo contentInfo2 = cMSEnvelopedData.getContentInfo();
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(contentInfo2.getContent());
            FirmadoyEnsobretadoBis firmadoyEnsobretadoBis = new FirmadoyEnsobretadoBis(new DERInteger(1), (DERSet)aSN1Sequence2.getObjectAt(1), new DERSet(aSN1EncodableVector.get(0)), (ASN1Sequence)aSN1Sequence2.getObjectAt(2), new DERSet(aSN1EncodableVector4), (DERSet)aSN1Sequence.getObjectAt(4));
            outputStream.write(firmadoyEnsobretadoBis.getEncoded());
            return true;
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error al crear el sobre", 3000);
        }
    }

    public void getEnvelopedSignedData(ASN1EncodableVector aSN1EncodableVector, SgiCertificado[] sgiCertificadoArray, SgiCertificado[] sgiCertificadoArray2, SgiLlavePrivada[] sgiLlavePrivadaArray, int n, int[] nArray, InputStream inputStream, OutputStream outputStream) throws SgiCriptoException {
        try {
            CMSEnvelopedAndSignedDataStreamGenerator cMSEnvelopedAndSignedDataStreamGenerator = new CMSEnvelopedAndSignedDataStreamGenerator();
            cMSEnvelopedAndSignedDataStreamGenerator.addCerts(aSN1EncodableVector);
            cMSEnvelopedAndSignedDataStreamGenerator.addRecipients(sgiCertificadoArray, n);
            cMSEnvelopedAndSignedDataStreamGenerator.addSigner(sgiLlavePrivadaArray[0].getLlave(), sgiCertificadoArray2[0], "1.2.246.530.1.2.15.2.4", CMSSignedGenerator.DIGEST_SHA1, null, null);
            outputStream = cMSEnvelopedAndSignedDataStreamGenerator.open(outputStream, AlgSimetrico.getAlgoritmoObjId(n).getId(), sgiLlavePrivadaArray[0].getLlave(), "BC");
            Streams.pipeAll(inputStream, outputStream);
            outputStream.close();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException("No se encuentra el algoritmo de cifrado.", 3001);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SgiCriptoException("Llave simetrica invalida.", 3002);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SgiCriptoException("No se encontr\u00f3 proveedor.", 3003);
        }
        catch (CMSException cMSException) {
            throw new SgiCriptoException(cMSException.getMessage(), 3004);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error IO." + iOException.getMessage(), 3005);
        }
    }

    public boolean generaFirmadoyEnsobretado(SgiCertificado[] sgiCertificadoArray, SgiCertificado[] sgiCertificadoArray2, SgiLlavePrivada[] sgiLlavePrivadaArray, int n, InputStream inputStream, int[] nArray, OutputStream outputStream) throws SgiCriptoException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(bufferedInputStream.available());
            this.sobre = new Ensobretado();
            Key key = this.sobre.generaLlaveSimetrica(n);
            EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(this.sobre.getEncryptedContentInfo(bufferedInputStream, key, n));
            ((FirmaSimetrica)this.delegado).setParametros(key, encryptedContentInfo);
            ASN1EncodableVector aSN1EncodableVector = this.sobre.getRecipientsInfo(sgiCertificadoArray, n, key);
            ASN1EncodableVector aSN1EncodableVector2 = Util.algoritmos(nArray);
            ASN1EncodableVector aSN1EncodableVector3 = Util.certificados(sgiCertificadoArray);
            ASN1EncodableVector aSN1EncodableVector4 = Util.certificados(sgiCertificadoArray2);
            ASN1EncodableVector aSN1EncodableVector5 = new ASN1EncodableVector();
            int n2 = 0;
            while (n2 < aSN1EncodableVector3.size()) {
                aSN1EncodableVector5.add(aSN1EncodableVector3.get(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < aSN1EncodableVector4.size()) {
                aSN1EncodableVector5.add(aSN1EncodableVector4.get(n3));
                ++n3;
            }
            bufferedInputStream.reset();
            ASN1EncodableVector aSN1EncodableVector6 = this.getSignerInfos(aSN1EncodableVector4, sgiLlavePrivadaArray, aSN1EncodableVector2, bufferedInputStream);
            SignedAndEnveloped signedAndEnveloped = new SignedAndEnveloped(new DERInteger(1), new DERSet(aSN1EncodableVector), new DERSet(aSN1EncodableVector2.get(0)), encryptedContentInfo, new DERSet(aSN1EncodableVector5), new DERSet(aSN1EncodableVector6));
            outputStream.write(signedAndEnveloped.getEncoded());
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error al crear el sobre. " + iOException.getMessage(), 3000);
        }
        return true;
    }
}

