/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.sobre;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.SgiDigest;
import mx.gob.sat.sgi.SgiCripto.SgiLlavePrivada;
import mx.gob.sat.sgi.SgiCripto.sobre.DelegadoDeFirmas;
import mx.gob.sat.sgi.SgiCripto.sobre.FirmaRSA;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignedDataParser;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.util.io.Streams;

public class Firmado {
    private Hashtable tabla_de_hashes = null;
    private SignedData s_data = null;
    private SignedDataParser s_data_P = null;
    protected DelegadoDeFirmas delegado = null;
    protected byte[] data_bytes = null;
    private boolean bGenerar = false;

    public void setGenerar(boolean bl) {
        this.bGenerar = bl;
    }

    private void ver_Firmado() {
    }

    public Firmado() {
        this.tabla_de_hashes = new Hashtable();
    }

    public Firmado(DelegadoDeFirmas delegadoDeFirmas) {
        this.delegado = delegadoDeFirmas;
        this.tabla_de_hashes = new Hashtable();
    }

    public boolean generaFirmado(SgiCertificado[] sgiCertificadoArray, SgiLlavePrivada[] sgiLlavePrivadaArray, int[] nArray, InputStream inputStream, OutputStream outputStream) throws SgiCriptoException, IOException {
        this.bGenerar = true;
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            X509Certificate x509Certificate = sgiCertificadoArray[0].getX509_Certificate();
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
            arrayList.add(x509Certificate);
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            cMSSignedDataStreamGenerator.addSigner(sgiLlavePrivadaArray[0].getLlave(), x509Certificate, CMSSignedGenerator.DIGEST_SHA1, "BC");
            cMSSignedDataStreamGenerator.addCertificatesAndCRLs(certStore);
            outputStream = cMSSignedDataStreamGenerator.open(outputStream, true);
            Streams.pipeAll(inputStream, outputStream);
            outputStream.close();
            return true;
        }
        catch (SgiCriptoException sgiCriptoException) {
            throw new SgiCriptoException(sgiCriptoException.getMessage(), 1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException(noSuchAlgorithmException.getMessage(), 1);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SgiCriptoException(noSuchProviderException.getMessage(), 1);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SgiCriptoException(invalidKeyException.getMessage(), 1);
        }
        catch (CertStoreException certStoreException) {
            throw new SgiCriptoException(certStoreException.getMessage(), 1);
        }
        catch (CMSException cMSException) {
            throw new SgiCriptoException(cMSException.getMessage(), 1);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SgiCriptoException(invalidAlgorithmParameterException.getMessage(), 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SgiCriptoException(illegalArgumentException.getMessage(), 1);
        }
    }

    public SignedData getSignedData(ASN1EncodableVector aSN1EncodableVector, ASN1EncodableVector aSN1EncodableVector2, ASN1EncodableVector aSN1EncodableVector3, InputStream inputStream) throws IOException {
        DERInteger dERInteger = new DERInteger(1);
        DERSet dERSet = new DERSet(aSN1EncodableVector);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(this.readDatos(inputStream)));
        DERSet dERSet2 = new DERSet(aSN1EncodableVector3);
        ASN1Set aSN1Set = null;
        DERSet dERSet3 = new DERSet(aSN1EncodableVector2);
        return new SignedData(dERInteger, dERSet, contentInfo, dERSet2, aSN1Set, dERSet3);
    }

    public byte[] getEncryptedDigest(BufferedInputStream bufferedInputStream, AlgorithmIdentifier algorithmIdentifier, SgiLlavePrivada sgiLlavePrivada) throws IOException, SgiCriptoException {
        byte[] byArray = null;
        byte[] byArray2 = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(byArray2);
        byte[] byArray3 = this.getDigest(byArray2, algorithmIdentifier);
        if (byArray3 == null) {
            return null;
        }
        FirmaRSA firmaRSA = null;
        if (firmaRSA == null) {
            firmaRSA = new FirmaRSA();
        }
        byArray = firmaRSA.getFirmaCifrada(byArray3, algorithmIdentifier, sgiLlavePrivada);
        firmaRSA = null;
        byArray3 = null;
        return byArray;
    }

    protected byte[] readDatos(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        if (byArray == null) {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        return byArray;
    }

    protected byte[] readDatosEnPartes(InputStream inputStream, long l) throws IOException {
        byte[] byArray = null;
        int n = inputStream.available();
        long l2 = (long)n / l;
        if (byArray == null) {
            byArray = new byte[(int)l2];
            inputStream.read(byArray);
        }
        return byArray;
    }

    public byte[] getDigest(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) throws SgiCriptoException {
        byte[] byArray2 = null;
        String string = (String)this.tabla_de_hashes.get(algorithmIdentifier);
        if (string == null) {
            SgiDigest sgiDigest = new SgiDigest();
            byArray2 = sgiDigest.genDigest(SgiDigest.getAlgoritmoId(algorithmIdentifier), byArray, byArray.length);
            this.tabla_de_hashes.put(algorithmIdentifier, new String(byArray2));
        } else {
            byArray2 = string.getBytes();
        }
        return byArray2;
    }

    public boolean verifica(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, byte[] byArray2, X509CertificateStructure x509CertificateStructure) throws IOException, SgiCriptoException {
        SgiCertificado sgiCertificado = SgiCertificado.getInstance();
        sgiCertificado.inicia(1, new ByteArrayInputStream(x509CertificateStructure.getDEREncoded()));
        this.delegado = new FirmaRSA();
        byte[] byArray3 = this.delegado.getFirmaPlana(byArray2, sgiCertificado);
        byte[] byArray4 = this.getDigest(byArray, algorithmIdentifier);
        return Arrays.equals(byArray3, byArray4);
    }

    public boolean inicia(CMSSignedDataParser cMSSignedDataParser) {
        try {
            int n = cMSSignedDataParser.getVersion();
            InputStream inputStream = cMSSignedDataParser.getSignedContent().getContentStream();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(new ASN1InputStream(inputStream).readObject());
            this.s_data = new SignedData(aSN1Sequence);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public boolean inicia(DEREncodable dEREncodable) throws IOException, SgiCriptoException {
        this.s_data = new SignedData((ASN1Sequence)dEREncodable);
        return true;
    }

    protected boolean procesaFirma(byte[] byArray, X509CertificateStructure x509CertificateStructure, SignerInfo signerInfo) throws IOException, SgiCriptoException {
        AlgorithmIdentifier algorithmIdentifier = signerInfo.getDigestAlgorithm();
        byte[] byArray2 = signerInfo.getEncryptedDigest().getOctets();
        ASN1Set aSN1Set = signerInfo.getAuthenticatedAttributes();
        if (aSN1Set == null) {
            return this.verifica(byArray, algorithmIdentifier, byArray2, x509CertificateStructure);
        }
        return this.verifica(aSN1Set.getDEREncoded(), algorithmIdentifier, byArray2, x509CertificateStructure);
    }

    public boolean procesa(OutputStream outputStream, X509CertificateStructure x509CertificateStructure) throws IOException, SgiCriptoException {
        ContentInfo contentInfo = this.s_data.getContentInfo();
        X509CertificateStructure x509CertificateStructure2 = null;
        if (contentInfo.getContentType().equals(CMSObjectIdentifiers.data)) {
            Object object;
            if (x509CertificateStructure != null) {
                x509CertificateStructure2 = x509CertificateStructure;
            } else {
                object = this.extraerCertificados(null);
                if (((X509CertificateStructure[])object).length > 0) {
                    x509CertificateStructure2 = this.extraerCertificados(null)[0];
                } else {
                    throw new SgiCriptoException("El sobre no contiene certificados.", 6000);
                }
            }
            object = (ASN1OctetString)contentInfo.getContent();
            this.data_bytes = ((ASN1OctetString)object).getOctets();
            ASN1Set aSN1Set = this.s_data.getSignerInfos();
            SignerInfo[] signerInfoArray = this.extraerSigners(aSN1Set);
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateStructure2.getIssuer(), x509CertificateStructure2.getSerialNumber());
            int n = 0;
            while (n < signerInfoArray.length) {
                if (signerInfoArray[n].getIssuerAndSerialNumber().equals(issuerAndSerialNumber)) {
                    if (this.procesaFirma(this.data_bytes, x509CertificateStructure2, signerInfoArray[n])) {
                        outputStream.write(this.data_bytes);
                        return true;
                    }
                    return false;
                }
                ++n;
            }
        }
        return false;
    }

    public X509CertificateStructure[] extraerCertificados(ASN1Set aSN1Set) throws IOException, SgiCriptoException {
        ASN1Set aSN1Set2 = null;
        X509CertificateStructure[] x509CertificateStructureArray = null;
        if (this.s_data != null) {
            aSN1Set2 = this.s_data.getCertificates();
        } else if (aSN1Set != null) {
            aSN1Set2 = aSN1Set;
        }
        try {
            try {
                x509CertificateStructureArray = new X509CertificateStructure[aSN1Set2.size()];
                int n = 0;
                while (n < x509CertificateStructureArray.length) {
                    DERSequence dERSequence = (DERSequence)aSN1Set2.getObjectAt(n);
                    x509CertificateStructureArray[n] = new X509CertificateStructure(dERSequence);
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {
                x509CertificateStructureArray = new X509CertificateStructure[]{};
                Object var7_8 = null;
                return x509CertificateStructureArray;
            }
            Object var7_7 = null;
            return x509CertificateStructureArray;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            return x509CertificateStructureArray;
        }
    }

    protected SignerInfo[] extraerSigners(ASN1Set aSN1Set) {
        SignerInfo[] signerInfoArray = new SignerInfo[aSN1Set.size()];
        int n = 0;
        while (n < signerInfoArray.length) {
            DERSequence dERSequence = (DERSequence)aSN1Set.getObjectAt(n);
            signerInfoArray[n] = new SignerInfo(dERSequence);
            ++n;
        }
        return signerInfoArray;
    }

    public SignerInfo getSignerInfo(X509CertificateStructure x509CertificateStructure, SgiLlavePrivada sgiLlavePrivada, AlgorithmIdentifier algorithmIdentifier, BufferedInputStream bufferedInputStream) throws IOException, SgiCriptoException {
        SignerInfo signerInfo = null;
        DERInteger dERInteger = new DERInteger(1);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateStructure.getIssuer(), x509CertificateStructure.getSerialNumber());
        ASN1Set aSN1Set = null;
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
        byte[] byArray = this.getEncryptedDigest(bufferedInputStream, algorithmIdentifier, sgiLlavePrivada);
        DEROctetString dEROctetString = new DEROctetString(byArray);
        byArray = null;
        ASN1Set aSN1Set2 = null;
        System.out.println("getSignerInfo");
        signerInfo = new SignerInfo(dERInteger, issuerAndSerialNumber, algorithmIdentifier, aSN1Set, algorithmIdentifier2, dEROctetString, aSN1Set2);
        dERInteger = null;
        issuerAndSerialNumber = null;
        algorithmIdentifier2 = null;
        byArray = null;
        dEROctetString = null;
        return signerInfo;
    }

    public ASN1EncodableVector getSignerInfos(ASN1EncodableVector aSN1EncodableVector, SgiLlavePrivada[] sgiLlavePrivadaArray, ASN1EncodableVector aSN1EncodableVector2, BufferedInputStream bufferedInputStream) throws IOException, SgiCriptoException {
        ASN1EncodableVector aSN1EncodableVector3 = null;
        X509CertificateStructure x509CertificateStructure = null;
        if (sgiLlavePrivadaArray.length > 0 && aSN1EncodableVector.size() == sgiLlavePrivadaArray.length) {
            aSN1EncodableVector3 = new ASN1EncodableVector();
            int n = 0;
            while (n < sgiLlavePrivadaArray.length) {
                x509CertificateStructure = (X509CertificateStructure)aSN1EncodableVector.get(n);
                aSN1EncodableVector3.add(this.getSignerInfo(x509CertificateStructure, sgiLlavePrivadaArray[n], (AlgorithmIdentifier)aSN1EncodableVector2.get(n), bufferedInputStream));
                x509CertificateStructure = null;
                ++n;
            }
        }
        System.gc();
        return aSN1EncodableVector3;
    }

    public CMSSignedData getSignedData(SgiCertificado[] sgiCertificadoArray, SgiLlavePrivada[] sgiLlavePrivadaArray, int[] nArray, InputStream inputStream) throws SgiCriptoException {
        try {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            int n = 0;
            while (n < sgiCertificadoArray.length) {
                object = sgiCertificadoArray[n].getX509_Certificate();
                arrayList.add((X509Certificate)object);
                cMSSignedDataStreamGenerator.addSigner(sgiLlavePrivadaArray[0].getLlave(), (X509Certificate)object, CMSSignedGenerator.DIGEST_SHA1, "BC");
                ++n;
            }
            cMSSignedDataStreamGenerator.addCertificatesAndCRLs(certStore);
            object = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
            Streams.pipeAll(inputStream, (OutputStream)object);
            ((OutputStream)object).close();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            CMSSignedData cMSSignedData = new CMSSignedData(bufferedInputStream);
            return cMSSignedData;
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error IO. " + iOException.getMessage(), 6000);
        }
        catch (CertStoreException certStoreException) {
            throw new SgiCriptoException("Error en el certStore. " + certStoreException.getMessage(), 6000);
        }
        catch (CMSException cMSException) {
            throw new SgiCriptoException("Error al generar el sobre. " + cMSException.getMessage(), 6000);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException("No se encontr\u00f3 algoritmo. " + noSuchAlgorithmException.getMessage(), 6000);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SgiCriptoException("No se cargo el proveedor. " + noSuchProviderException.getMessage(), 6000);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SgiCriptoException("Llave inv\u00e1lida. " + invalidKeyException.getMessage(), 6000);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SgiCriptoException("Parametros del algoritmo invalidos. " + invalidAlgorithmParameterException.getMessage(), 6000);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SgiCriptoException("Argumentos inv\u00e1lidos. " + illegalArgumentException.getMessage(), 6000);
        }
    }
}

