/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.sobre;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import mx.gob.sat.sgi.SgiCripto.AlgSimetrico;
import mx.gob.sat.sgi.SgiCripto.CCifrado;
import mx.gob.sat.sgi.SgiCripto.CCifradoSimetrico;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCripto;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.SgiLlavePrivada;
import mx.gob.sat.sgi.SgiCripto.sobre.Util;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.io.Streams;

public class Ensobretado {
    private EncryptedContentInfo encryptedContentInfo = null;
    private DERSet destinatios = null;
    private int idenSimetrico;
    private boolean iniciado = false;

    private void ver_Ensobretado() {
    }

    public boolean inicia(DEREncodable dEREncodable) throws SgiCriptoException {
        EnvelopedData envelopedData = new EnvelopedData((ASN1Sequence)dEREncodable);
        this.encryptedContentInfo = envelopedData.getEncryptedContentInfo();
        this.destinatios = (DERSet)envelopedData.getRecipientInfos();
        this.idenSimetrico = this.getIdenSimetrico(this.encryptedContentInfo);
        this.iniciado = true;
        return true;
    }

    public void procesa(X509CertificateStructure x509CertificateStructure, SgiLlavePrivada sgiLlavePrivada, OutputStream outputStream) throws SgiCriptoException, IOException {
        if (!this.iniciado) {
            throw new SgiCriptoException("Sobre no iniciado.", 2001);
        }
        ASN1EncodableVector aSN1EncodableVector = this.getRecipientsInfo();
        Key key = this.getLlaveSimetrica(x509CertificateStructure, sgiLlavePrivada, aSN1EncodableVector, null);
        byte[] byArray = this.getContent(key, this.encryptedContentInfo);
        outputStream.write(byArray);
    }

    private RecipientInfo destinatarioInfo(X509CertificateStructure x509CertificateStructure, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        RecipientInfo recipientInfo = null;
        KeyTransRecipientInfo keyTransRecipientInfo = null;
        RecipientIdentifier recipientIdentifier = null;
        IssuerAndSerialNumber issuerAndSerialNumber = null;
        issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateStructure.getIssuer(), x509CertificateStructure.getSerialNumber().getValue());
        recipientIdentifier = new RecipientIdentifier(issuerAndSerialNumber);
        keyTransRecipientInfo = new KeyTransRecipientInfo(recipientIdentifier, algorithmIdentifier, aSN1OctetString);
        recipientInfo = new RecipientInfo(keyTransRecipientInfo);
        return recipientInfo;
    }

    public void generaEnsobretadoMod(SgiCertificado[] sgiCertificadoArray, int n, InputStream inputStream, OutputStream outputStream) throws SgiCriptoException {
        try {
            CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
            int n2 = 0;
            while (n2 < sgiCertificadoArray.length) {
                cMSEnvelopedDataStreamGenerator.addKeyTransRecipient(sgiCertificadoArray[n2].getX509_Certificate());
                ++n2;
            }
            outputStream = cMSEnvelopedDataStreamGenerator.open(outputStream, AlgSimetrico.getAlgoritmoObjId(n).getId(), "BC");
            Streams.pipeAll(inputStream, outputStream);
            outputStream.close();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SgiCriptoException("No se encontro algoritmo. " + noSuchProviderException.getMessage(), 2002);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException("No se encontro algoritmo. " + noSuchAlgorithmException.getMessage(), 2003);
        }
        catch (CMSException cMSException) {
            throw new SgiCriptoException("Error al crear el sobre. " + cMSException.getMessage(), 2005);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error IO. " + iOException.getMessage(), 2006);
        }
    }

    public void generaEnsobretado(SgiCertificado[] sgiCertificadoArray, int n, InputStream inputStream, OutputStream outputStream) throws SgiCriptoException {
        Key key = this.generaLlaveSimetrica(n);
        DERSequence dERSequence = this.getEncryptedContentInfo(inputStream, key, n);
        ASN1EncodableVector aSN1EncodableVector = this.getRecipientsInfo(sgiCertificadoArray, n, key);
        DERSequence dERSequence2 = this.getEnvelopedData(aSN1EncodableVector, dERSequence);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(PKCSObjectIdentifiers.envelopedData);
        aSN1EncodableVector2.add(new DERTaggedObject(true, 0, dERSequence2));
        DERSequence dERSequence3 = new DERSequence(aSN1EncodableVector2);
        try {
            outputStream.write(dERSequence3.getDEREncoded());
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error al escribir en la salida. " + iOException.getMessage(), 2003);
        }
    }

    public ASN1EncodableVector getRecipientsInfo(SgiCertificado[] sgiCertificadoArray, int n, Key key) throws SgiCriptoException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = Util.certificados(sgiCertificadoArray);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(key.getEncoded());
        int n2 = 0;
        while (n2 < sgiCertificadoArray.length) {
            CCifrado cCifrado = SgiCripto.inicia(sgiCertificadoArray[n2], null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cCifrado.cifra(byteArrayInputStream, byteArrayOutputStream);
            aSN1EncodableVector.add(this.destinatarioInfo((X509CertificateStructure)aSN1EncodableVector2.get(n2), algorithmIdentifier, new DEROctetString(byteArrayOutputStream.toByteArray())));
            ++n2;
        }
        return aSN1EncodableVector;
    }

    public DERSequence getEncryptedContentInfo(InputStream inputStream, Key key, int n) throws SgiCriptoException {
        AlgorithmIdentifier algorithmIdentifier = null;
        CCifradoSimetrico cCifradoSimetrico = new CCifradoSimetrico();
        cCifradoSimetrico.iniciaPk7(n);
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            byArray2 = new byte[inputStream.available()];
            inputStream.read(byArray2);
            byArray = cCifradoSimetrico.cifrarPk7(key, byArray2);
            byArray3 = cCifradoSimetrico.getPk7IV();
            algorithmIdentifier = new AlgorithmIdentifier(AlgSimetrico.getAlgoritmoObjId(n), new DEROctetString(byArray3));
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Sobre no iniciado.", 2004);
        }
        DERSequence dERSequence = this.getEncryptedContentInfo(algorithmIdentifier, byArray);
        return dERSequence;
    }

    public DERSequence getEncryptedContentInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(PKCSObjectIdentifiers.data);
        aSN1EncodableVector.add(algorithmIdentifier);
        aSN1EncodableVector.add(new DERTaggedObject(false, 0, new DEROctetString(byArray)));
        return new DERSequence(aSN1EncodableVector);
    }

    public DERSequence getEnvelopedData(ASN1EncodableVector aSN1EncodableVector, DERSequence dERSequence) {
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new DERInteger(0));
        aSN1EncodableVector2.add(new DERSet(aSN1EncodableVector));
        aSN1EncodableVector2.add(dERSequence);
        DERSequence dERSequence2 = new DERSequence(aSN1EncodableVector2);
        return dERSequence2;
    }

    public Key generaLlaveSimetrica(int n) throws SgiCriptoException {
        int n2 = -1;
        KeyGenerator keyGenerator = null;
        try {
            String[] stringArray = AlgSimetrico.getAlgoritmo(n);
            keyGenerator = KeyGenerator.getInstance(stringArray[0]);
            n2 = Integer.parseInt(stringArray[2]);
            keyGenerator.init(n2);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException("Algoritmo no encontrado. " + noSuchAlgorithmException.getMessage(), 2005);
        }
    }

    private DEROctetString getLlaveCifradaDest(X509CertificateStructure x509CertificateStructure, ASN1EncodableVector aSN1EncodableVector) {
        DEROctetString dEROctetString = null;
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateStructure.getIssuer(), x509CertificateStructure.getSerialNumber().getValue());
        int n = 0;
        while (n < aSN1EncodableVector.size()) {
            RecipientInfo recipientInfo = (RecipientInfo)aSN1EncodableVector.get(n);
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(recipientInfo.toASN1Object());
            IssuerAndSerialNumber issuerAndSerialNumber2 = new IssuerAndSerialNumber((ASN1Sequence)aSN1Sequence.getObjectAt(1));
            if (Util.verifUser(issuerAndSerialNumber, issuerAndSerialNumber2)) {
                dEROctetString = (DEROctetString)aSN1Sequence.getObjectAt(3);
                break;
            }
            ++n;
        }
        return dEROctetString;
    }

    public Key getLlaveSimetrica(X509CertificateStructure x509CertificateStructure, SgiLlavePrivada sgiLlavePrivada, ASN1EncodableVector aSN1EncodableVector, EncryptedContentInfo encryptedContentInfo) throws SgiCriptoException {
        SecretKeySpec secretKeySpec = null;
        DEROctetString dEROctetString = null;
        dEROctetString = this.getLlaveCifradaDest(x509CertificateStructure, aSN1EncodableVector);
        if (dEROctetString == null) {
            throw new SgiCriptoException("El certificado dado no se encuentra entre los destinatarios.", 2007);
        }
        CCifrado cCifrado = SgiCripto.inicia(null, sgiLlavePrivada);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        cCifrado.descifra(dEROctetString.getOctetStream(), byteArrayOutputStream);
        if (encryptedContentInfo != null) {
            this.idenSimetrico = this.getIdenSimetrico(encryptedContentInfo);
        }
        secretKeySpec = new SecretKeySpec(byteArrayOutputStream.toByteArray(), AlgSimetrico.getAlgoritmo(this.idenSimetrico)[0]);
        return secretKeySpec;
    }

    public byte[] getContent(Key key, EncryptedContentInfo encryptedContentInfo) throws SgiCriptoException {
        AlgorithmIdentifier algorithmIdentifier = encryptedContentInfo.getContentEncryptionAlgorithm();
        DEROctetString dEROctetString = (DEROctetString)algorithmIdentifier.getParameters().getDERObject();
        int n = AlgSimetrico.getAlgoritmoId(algorithmIdentifier);
        byte[] byArray = dEROctetString.getOctets();
        byte[] byArray2 = null;
        CCifradoSimetrico cCifradoSimetrico = new CCifradoSimetrico();
        cCifradoSimetrico.iniciaPk7(n);
        byArray2 = cCifradoSimetrico.descifrarPk7(key, byArray, encryptedContentInfo.getEncryptedContent().getOctets());
        return byArray2;
    }

    public ASN1EncodableVector getRecipientsInfo() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n < this.destinatios.size()) {
            DEREncodable dEREncodable = this.destinatios.getObjectAt(n);
            RecipientInfo recipientInfo = new RecipientInfo(dEREncodable.getDERObject());
            aSN1EncodableVector.add(recipientInfo);
            ++n;
        }
        return aSN1EncodableVector;
    }

    private int getIdenSimetrico(EncryptedContentInfo encryptedContentInfo) throws SgiCriptoException {
        int n = 0;
        AlgorithmIdentifier algorithmIdentifier = encryptedContentInfo.getContentEncryptionAlgorithm();
        n = AlgSimetrico.getAlgoritmoId(algorithmIdentifier);
        return n;
    }

    public CMSEnvelopedData getEnvelopedData(SgiCertificado[] sgiCertificadoArray, int n, InputStream inputStream) throws SgiCriptoException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
            int n2 = 0;
            while (n2 < sgiCertificadoArray.length) {
                cMSEnvelopedDataStreamGenerator.addKeyTransRecipient(sgiCertificadoArray[n2].getX509_Certificate());
                ++n2;
            }
            OutputStream outputStream = byteArrayOutputStream;
            outputStream = cMSEnvelopedDataStreamGenerator.open(outputStream, AlgSimetrico.getAlgoritmoObjId(n).getId(), "BC");
            Streams.pipeAll(inputStream, outputStream);
            outputStream.close();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(bufferedInputStream);
            return cMSEnvelopedData;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException("No se encontro el algoritmo. " + noSuchAlgorithmException.getMessage(), 2007);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SgiCriptoException("No se carg\u00f3 proveedor. " + noSuchProviderException.getMessage(), 2008);
        }
        catch (CMSException cMSException) {
            throw new SgiCriptoException("No se creo el sobre ensobretado. " + cMSException.getMessage(), 2009);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error IO. " + iOException.getMessage(), 2010);
        }
    }

    public DERSequence getEncryptedContentInfo(ASN1Sequence aSN1Sequence, DERTaggedObject dERTaggedObject) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(PKCSObjectIdentifiers.data);
        aSN1EncodableVector.add(aSN1Sequence);
        aSN1EncodableVector.add(dERTaggedObject);
        return new DERSequence(aSN1EncodableVector);
    }
}

