/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.sobre;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.sobre.Ensobretado;
import mx.gob.sat.sgi.SgiCripto.sobre.Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;

public class CMSEnvelopedAndSignedDataStreamGenerator
extends CMSEnvelopedGenerator {
    private Object _originatorInfo = null;
    private Object _unprotectedAttributes = null;
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;
    private SecureRandom rand = new SecureRandom();
    private ASN1EncodableVector recipientsInfo = null;
    private List _messageDigests = new ArrayList();
    private List _signerInfs = new ArrayList();
    private ASN1EncodableVector certificados = null;

    private void ver_CMSEnvelopedAndSignedDataStreamGenerator() {
    }

    public CMSEnvelopedAndSignedDataStreamGenerator() {
    }

    public CMSEnvelopedAndSignedDataStreamGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void setBEREncodeRecipients(boolean bl) {
        this._berEncodeRecipientSet = bl;
    }

    private OutputStream open(OutputStream outputStream, String string, KeyGenerator keyGenerator, PrivateKey privateKey, Provider provider) throws NoSuchAlgorithmException, CMSException {
        Provider provider2 = keyGenerator.getProvider();
        SecretKey secretKey = keyGenerator.generateKey();
        AlgorithmParameters algorithmParameters = this.generateParameters(string, secretKey, provider2);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Iterator iterator = this._signerInfs.iterator();
        while (iterator.hasNext()) {
            SignerInf signerInf = (SignerInf)iterator.next();
            try {
                aSN1EncodableVector2.add(signerInf.toSignerInfo(CMSObjectIdentifiers.data));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for signature.", invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CMSException("error creating signature.", signatureException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new CMSException("error creating sid.", certificateEncodingException);
            }
        }
        return this.open(outputStream, string, secretKey, algorithmParameters, aSN1EncodableVector, aSN1EncodableVector2, privateKey, provider2);
    }

    protected OutputStream open(OutputStream outputStream, String string, SecretKey secretKey, AlgorithmParameters algorithmParameters, ASN1EncodableVector aSN1EncodableVector, ASN1EncodableVector aSN1EncodableVector2, PrivateKey privateKey, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.open(outputStream, string, secretKey, algorithmParameters, aSN1EncodableVector, aSN1EncodableVector2, privateKey, Security.getProvider(string2));
    }

    protected OutputStream open(OutputStream outputStream, String string, SecretKey secretKey, AlgorithmParameters algorithmParameters, ASN1EncodableVector aSN1EncodableVector, ASN1EncodableVector aSN1EncodableVector2, PrivateKey privateKey, Provider provider) throws NoSuchAlgorithmException, CMSException {
        try {
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
            bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedAndEnvelopedData);
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            bERSequenceGenerator2.addObject(new DERInteger(1));
            bERSequenceGenerator2.addObject(new BERSet(this.recipientsInfo));
            bERSequenceGenerator2.addObject(new BERSet(new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, null)));
            BERSequence bERSequence = new BERSequence(this.certificados);
            bERSequenceGenerator2.addObject(new BERTaggedObject(false, 0, bERSequence));
            bERSequenceGenerator2.addObject(new BERSet(aSN1EncodableVector2));
            AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(string, algorithmParameters);
            Cipher cipher = Cipher.getInstance(string, provider.getName());
            cipher.init(1, (Key)secretKey, algorithmParameters, this.rand);
            BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
            bERSequenceGenerator3.addObject(CMSObjectIdentifiers.data);
            bERSequenceGenerator3.addObject(algorithmIdentifier);
            BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(bERSequenceGenerator3.getRawOutputStream(), 0, false);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(bEROctetStringGenerator.getOctetOutputStream(), cipher);
            return new CmsEnvelopedSignedDataOutputStream(cipherOutputStream, bERSequenceGenerator, null, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        return null;
    }

    public OutputStream open(OutputStream outputStream, String string, PrivateKey privateKey, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(outputStream, string, privateKey, Security.getProvider(string2));
    }

    public OutputStream open(OutputStream outputStream, String string, PrivateKey privateKey, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string, provider);
        keyGenerator.init(this.rand);
        return this.open(outputStream, string, keyGenerator, privateKey, provider);
    }

    public OutputStream open(OutputStream outputStream, String string, int n, PrivateKey privateKey, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(outputStream, string, n, privateKey, Security.getProvider(string2));
    }

    public OutputStream open(OutputStream outputStream, String string, int n, PrivateKey privateKey, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string, provider);
        keyGenerator.init(n, this.rand);
        return this.open(outputStream, string, keyGenerator, privateKey, provider);
    }

    public void addCerts(ASN1EncodableVector aSN1EncodableVector) {
        this.certificados = aSN1EncodableVector;
    }

    public void addRecipients(SgiCertificado[] sgiCertificadoArray, int n) {
        try {
            Ensobretado ensobretado = new Ensobretado();
            Key key = ensobretado.generaLlaveSimetrica(n);
            this.recipientsInfo = ensobretado.getRecipientsInfo(sgiCertificadoArray, n, key);
        }
        catch (SgiCriptoException sgiCriptoException) {
            sgiCriptoException.printStackTrace();
        }
    }

    public void addSigner(PrivateKey privateKey, SgiCertificado sgiCertificado, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws NoSuchAlgorithmException, InvalidKeyException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string2, "BC");
            X509CertificateStructure x509CertificateStructure = (X509CertificateStructure)Util.certificados(new SgiCertificado[]{sgiCertificado}).get(0);
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateStructure.getIssuer(), x509CertificateStructure.getSerialNumber());
            SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
            SignerInf signerInf = new SignerInf(privateKey, signerIdentifier, string2, string, null, null, messageDigest, Security.getProvider("BC"));
            this._signerInfs.add(signerInf);
            this._messageDigests.add(messageDigest);
        }
        catch (SgiCriptoException sgiCriptoException) {
            sgiCriptoException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
    }

    protected Map getBaseParameters(DERObjectIdentifier dERObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("contentType", dERObjectIdentifier);
        hashMap.put("digestAlgID", algorithmIdentifier);
        hashMap.put("digest", byArray.clone());
        return hashMap;
    }

    protected ASN1Set getAttributeSet(AttributeTable attributeTable) {
        if (attributeTable != null) {
            return new DERSet(attributeTable.toASN1EncodableVector());
        }
        return null;
    }

    private class SignerInf {
        private final PrivateKey _key;
        private final SignerIdentifier _signerIdentifier;
        private final String _digestOID;
        private final String _encOID;
        private final CMSAttributeTableGenerator _sAttr;
        private final CMSAttributeTableGenerator _unsAttr;
        private final MessageDigest _digest;
        private final Provider _sigProvider;

        SignerInf(PrivateKey privateKey, SignerIdentifier signerIdentifier, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, MessageDigest messageDigest, Provider provider) {
            this._key = privateKey;
            this._signerIdentifier = signerIdentifier;
            this._digestOID = string;
            this._encOID = string2;
            this._sAttr = cMSAttributeTableGenerator;
            this._unsAttr = cMSAttributeTableGenerator2;
            this._digest = messageDigest;
            this._sigProvider = provider;
        }

        AlgorithmIdentifier getDigestAlgorithmID() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this._digestOID), DERNull.INSTANCE);
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier) throws IOException, SignatureException, CertificateEncodingException, InvalidKeyException, NoSuchAlgorithmException {
            Object object;
            String string = this._digestOID;
            String string2 = this._encOID;
            String string3 = "SHA1withRSA";
            AlgorithmIdentifier algorithmIdentifier = this.getDigestAlgorithmID();
            byte[] byArray = this._digest.digest();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(this._digestOID, byArray.clone());
            byte[] byArray2 = byArray;
            ASN1Set aSN1Set = null;
            if (!string2.equals("1.2.246.530.1.2.15.2.4")) {
                throw new SignatureException("algorithm: " + string2 + " not supported in base signatures.");
            }
            Object object2 = new DigestInfo(algorithmIdentifier, byArray);
            byArray2 = ((ASN1Encodable)object2).getEncoded("DER");
            Signature signature = Signature.getInstance("Sha1withRSA");
            signature.initSign(this._key, CMSEnvelopedAndSignedDataStreamGenerator.this.rand);
            signature.update(byArray2);
            object2 = signature.sign();
            ASN1Set aSN1Set2 = null;
            if (this._unsAttr != null) {
                object = CMSEnvelopedAndSignedDataStreamGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
                object.put("encryptedDigest", object2.clone());
                AttributeTable attributeTable = this._unsAttr.getAttributes(Collections.unmodifiableMap(object));
                aSN1Set2 = CMSEnvelopedAndSignedDataStreamGenerator.this.getAttributeSet(attributeTable);
            }
            object = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
            return new SignerInfo(this._signerIdentifier, algorithmIdentifier, aSN1Set, (AlgorithmIdentifier)object, new DEROctetString((byte[])object2), aSN1Set2);
        }
    }

    private class CmsEnvelopedSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _envGen;
        private BERSequenceGenerator _eiGen;

        public CmsEnvelopedSignedDataOutputStream(OutputStream outputStream, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = outputStream;
            this._cGen = bERSequenceGenerator;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            this._out.close();
            this._cGen.close();
        }
    }
}

