/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.ara.pki.comunicacion;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.Cripto;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.CriptografiaException;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.Firma;
import mx.gob.sat.sgi.SgiCripto.ara.pki.comunicacion.MensajesException;
import mx.gob.sat.sgi.SgiCripto.ara.pki.comunicacion.operaciones.IOperaciones;
import mx.gob.sat.sgi.SgiCripto.ara.pki.comunicacion.operaciones.Operacion;
import mx.gob.sat.sgi.SgiCripto.ara.util.ByteCert;
import mx.gob.sat.sgi.SgiCripto.ara.util.ConvBytesException;
import mx.gob.sat.sgi.SgiCripto.ara.util.UtilBytes;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class Mensajes {
    private byte[] BMensaje = new byte[32768];
    private byte Destino = 0;
    protected X509Certificate CertLocal = null;
    protected RSAPrivateKeyStructure PvKeyLocal = null;
    protected X509Certificate CertRmt = null;
    private Operacion[] Oper = null;
    private boolean Iniciado = false;

    private void ver_Mensajes() {
    }

    public void inicia(byte by, IOperaciones iOperaciones, InputStream inputStream, InputStream inputStream2, InputStream inputStream3, String string) throws CriptografiaException {
        this.Destino = by;
        this.Oper = iOperaciones.getOperaciones();
        if (inputStream != null) {
            this.CertRmt = Cripto.ObtieneCert(inputStream);
        }
        if (inputStream2 != null) {
            this.CertLocal = Cripto.ObtieneCert(inputStream2);
            if (inputStream3 != null) {
                this.PvKeyLocal = Cripto.ObtienePvKey(inputStream3, string);
            }
        }
        this.Iniciado = true;
    }

    public byte getIDestino() {
        return this.BMensaje[0];
    }

    public void setIDestino(byte by) {
        this.BMensaje[0] = by;
    }

    public int getIOperacion() {
        return this.BMensaje[1];
    }

    public void setIOperacion(int n) {
        this.BMensaje[1] = (byte)n;
    }

    public int getITamCuerpo() throws ConvBytesException {
        return UtilBytes.bytes2int((byte)0, (byte)0, this.BMensaje[2], this.BMensaje[3]);
    }

    public void setITamCuerpo(int n) throws ConvBytesException {
        byte[] byArray = UtilBytes.short2bytes((short)n);
        System.arraycopy(byArray, 0, this.BMensaje, 2, byArray.length);
    }

    public int getITamFirma() throws ConvBytesException {
        byte[] byArray = new byte[4];
        System.arraycopy(this.BMensaje, 4, byArray, 0, byArray.length);
        return UtilBytes.bytes2int(byArray);
    }

    public void setITamFirma(int n) throws ConvBytesException {
        byte[] byArray = UtilBytes.int2bytes(n);
        System.arraycopy(byArray, 0, this.BMensaje, 4, byArray.length);
    }

    private void limpia(byte[] byArray) throws ConvBytesException {
        int n = this.getITamCuerpo();
        int n2 = 0;
        while (n2 < n + 4) {
            byArray[n2] = 0;
            ++n2;
        }
    }

    public boolean setMensaje(String string, String[] stringArray, byte[] byArray) throws ConvBytesException, CriptografiaException, InvalidCipherTextException {
        if (!this.Iniciado) {
            return false;
        }
        int n = 1;
        int n2 = 0;
        this.limpia(this.BMensaje);
        Operacion operacion = this.getOperacion(string);
        this.setIDestino(this.Destino);
        this.setIOperacion(operacion.getNumOper());
        int n3 = byArray != null ? operacion.getFormato() - 1 : operacion.getFormato();
        int n4 = operacion.getFirmado() ? 8 : 4;
        if (operacion.getFormato() != 0) {
            int n5 = 0;
            while (n5 < n3) {
                byte[] byArray2 = UtilBytes.getBytes(stringArray[n5]);
                System.arraycopy(byArray2, 0, this.BMensaje, n4, byArray2.length);
                n4 = n4 + byArray2.length + 1;
                n2 = n2 + byArray2.length + 1;
                if (n == operacion.getFormato()) break;
                ++n;
                ++n5;
            }
            if (byArray != null) {
                System.arraycopy(byArray, 0, this.BMensaje, n4, byArray.length);
                n2 += byArray.length + 1;
            }
        }
        this.setITamCuerpo(n2);
        if (operacion.getFirmado()) {
            this.Firmar();
        }
        return true;
    }

    public String[] getMensaje(boolean bl, ByteCert byteCert) throws ConvBytesException, CriptografiaException {
        if (!this.Iniciado) {
            return null;
        }
        Operacion operacion = this.getOperacion(this.getIOperacion());
        String[] stringArray = null;
        if (operacion.getFirmado()) {
            if (this.VerificaFirma()) {
                stringArray = this.getMensaje(bl, byteCert, operacion.getFormato(), 8);
            }
        } else {
            stringArray = this.getMensaje(bl, byteCert, operacion.getFormato(), 4);
        }
        return stringArray;
    }

    private String[] Split(int n, int n2, int n3, boolean bl) {
        String[] stringArray = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n7 = bl ? n - 1 : n;
        stringArray = new String[n7];
        int n8 = n2;
        while (n4 < n7) {
            if (this.BMensaje[n8] == 0) {
                stringArray[n4] = new String(this.BMensaje, n2 + n5 + n4, n6);
                ++n4;
                n5 += n6;
                n6 = 0;
            } else {
                ++n6;
            }
            ++n8;
        }
        return stringArray;
    }

    private String[] getMensaje(boolean bl, ByteCert byteCert, int n, int n2) throws ConvBytesException {
        if (!this.Iniciado) {
            return null;
        }
        int n3 = 0;
        String[] stringArray = null;
        if (n2 == 4) {
            n3 = this.getITamCuerpo();
        } else if (n2 == 8) {
            n3 = this.getITamCuerpo() - n2 - this.getITamFirma() + n;
        }
        stringArray = this.Split(n, n2, n3, bl);
        if (bl) {
            int n4 = n;
            int n5 = 0;
            while (n5 < n - 1) {
                n4 += stringArray[n5].length();
                ++n5;
            }
            byteCert.setTamByte(n3 - n4);
            byte[] byArray = byteCert.creaByte();
            System.arraycopy(this.BMensaje, n4 - 1 + n2, byArray, 0, n3 - n4);
            byteCert.setByte(byArray);
            String[] stringArray2 = new String[n - 1];
            int n6 = 0;
            while (n6 < n - 1) {
                stringArray2[n6] = stringArray[n6];
                ++n6;
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    protected Operacion getOperacion(int n) {
        int n2 = 0;
        while (n2 < this.Oper.length) {
            if (this.Oper[n2].getNumOper() == n) {
                return this.Oper[n2];
            }
            ++n2;
        }
        return null;
    }

    protected Operacion getOperacion(String string) {
        int n = 0;
        while (n < this.Oper.length) {
            if (this.Oper[n].getDesc().compareTo(string) == 0) {
                return this.Oper[n];
            }
            ++n;
        }
        return null;
    }

    public boolean esOperacion(String string) {
        Operacion operacion = this.getOperacion(string);
        return operacion.getDesc().compareTo(string) == 0;
    }

    private boolean Firmar() throws ConvBytesException, CriptografiaException, InvalidCipherTextException {
        if (!this.Iniciado) {
            return false;
        }
        byte[] byArray = new byte[this.getITamCuerpo()];
        System.arraycopy(this.BMensaje, 8, byArray, 0, this.getITamCuerpo());
        byte[] byArray2 = Firma.generaFirma(this.PvKeyLocal, byArray);
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, this.BMensaje, this.getITamCuerpo() + 8, byArray2.length);
            this.setITamFirma(byArray2.length);
            return true;
        }
        return false;
    }

    private boolean VerificaFirma() throws ConvBytesException, CriptografiaException {
        if (!this.Iniciado) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getOperacion(this.getIOperacion()).getFormato();
        n2 = this.getITamFirma();
        n = this.getITamCuerpo() - 8 - n2 + 4;
        n3 = this.getITamCuerpo() - n2 + n4 - 1;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.BMensaje, n3, byArray, 0, byArray.length);
        System.arraycopy(this.BMensaje, 8, byArray2, 0, n);
        bl = Firma.verificaFirma(this.CertRmt, byArray2, byArray);
        return bl;
    }

    public boolean write(OutputStream outputStream) throws MensajesException, ConvBytesException {
        if (!this.Iniciado) {
            return false;
        }
        boolean bl = false;
        try {
            if (this.getOperacion(this.getIOperacion()).getFormato() == 0) {
                outputStream.write(this.BMensaje, 0, 4);
            } else {
                int n = 0;
                if (this.getOperacion(this.getIOperacion()).getFirmado()) {
                    n = this.getITamFirma();
                }
                outputStream.write(this.BMensaje, 0, this.getITamCuerpo() + n + 4);
            }
            outputStream.flush();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
            throw new MensajesException(-1, "Mensajes.write(...): I/O Exception. Error al enviar mensaje. " + iOException.getMessage());
        }
        return bl;
    }

    public boolean read(InputStream inputStream) throws MensajesException, ConvBytesException {
        if (!this.Iniciado) {
            return false;
        }
        boolean bl = false;
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 4;
            this.limpia(this.BMensaje);
            n = inputStream.read(this.BMensaje, 0, 4);
            int n4 = n2 = this.getITamCuerpo();
            while (n < n2 + 4) {
                n = inputStream.read(this.BMensaje, n3, n4);
                n3 += n;
                if ((n4 -= n) == 0) break;
            }
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
            throw new MensajesException(-100, "Mensajes.read(...): I/O Exception. Error en la lectura de datos del socket." + iOException.getMessage());
        }
        return bl;
    }

    public boolean getIniciado() {
        return this.Iniciado;
    }
}

