/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SgiLlavePrivada {
    private boolean iniciado = false;
    private PrivateKey llavePriv = null;

    private void ver_SgiLlavePrivada() {
    }

    public void inicia(InputStream inputStream, byte[] byArray) throws SgiCriptoException {
        if (inputStream == null || byArray == null) {
            throw new SgiCriptoException("Par\u00c3\u00a1metro nulo.", -4);
        }
        this.llavePriv = this.getLlavePriv(inputStream, byArray);
        try {
            inputStream.close();
            inputStream = null;
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error al cerrar el archivo.", 153);
        }
        this.iniciado = true;
    }

    public PrivateKey getLlave() throws SgiCriptoException {
        if (this.iniciado) {
            return this.llavePriv;
        }
        throw new SgiCriptoException("Objeto SgiLlavePrivada no inicializado.", 1000);
    }

    public RSAPrivateKey getRSAPrivateKey() throws SgiCriptoException {
        if (this.iniciado) {
            return (RSAPrivateKey)this.llavePriv;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean correspondenciaConCertificado(SgiCertificado sgiCertificado) throws SgiCriptoException {
        BigInteger bigInteger;
        boolean bl = false;
        if (!this.iniciado) throw new SgiCriptoException("Objeto SgiLlavePrivada no iniciado.", 1000);
        if (sgiCertificado == null) throw new SgiCriptoException("Objeto de certificado no iniciado.", 1000);
        RSAPrivateKey rSAPrivateKey = this.getRSAPrivateKey();
        BigInteger bigInteger2 = rSAPrivateKey.getModulus();
        if (bigInteger2.compareTo(bigInteger = sgiCertificado.getRSAPublicKey().getModulus()) != 0) return bl;
        return true;
    }

    private PrivateKeyInfo obtienePKInfoPKCS8(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, String string) throws SgiCriptoException {
        PrivateKeyInfo privateKeyInfo = null;
        byte[] byArray = null;
        byte[] byArray2 = new byte[8];
        int n = -1;
        String string2 = null;
        PBEParameterSpec pBEParameterSpec = null;
        try {
            AlgorithmIdentifier algorithmIdentifier = encryptedPrivateKeyInfo.getEncryptionAlgorithm();
            string2 = this.getPBE(algorithmIdentifier.getObjectId().getId());
            if (string2 == null) {
                throw new SgiCriptoException("PBE no soportado", 151);
            }
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string2);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            pBEKeySpec = null;
            secretKeyFactory = null;
            DERObject dERObject = algorithmIdentifier.toASN1Object();
            algorithmIdentifier = null;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(dERObject);
            dERObject = null;
            DEREncodable dEREncodable = aSN1Sequence.getObjectAt(1);
            aSN1Sequence = null;
            DERObject dERObject2 = dEREncodable.getDERObject();
            dEREncodable = null;
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(dERObject2);
            dERObject2 = null;
            DEREncodable dEREncodable2 = aSN1Sequence2.getObjectAt(0);
            DERInteger dERInteger = (DERInteger)aSN1Sequence2.getObjectAt(1);
            aSN1Sequence2 = null;
            byArray = dEREncodable2.getDERObject().getDEREncoded();
            dEREncodable2 = null;
            n = dERInteger.getValue().intValue();
            System.arraycopy(byArray, 2, byArray2, 0, 8);
            byArray = null;
            pBEParameterSpec = new PBEParameterSpec(byArray2, n);
            Cipher cipher = Cipher.getInstance(string2 + "/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKey, pBEParameterSpec);
            secretKey = null;
            pBEParameterSpec = null;
            byte[] byArray3 = cipher.doFinal(encryptedPrivateKeyInfo.getEncryptedData());
            cipher = null;
            privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(byArray3));
            byArray3 = null;
            return privateKeyInfo;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new SgiCriptoException("Llave PKCS8 Malformada", 151);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Llave PKCS8 Malformada", 151);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SgiCriptoException("Llave PKCS8 Malformada", 151);
        }
        catch (BadPaddingException badPaddingException) {
            throw new SgiCriptoException("Llave PKCS8 Malformada", 151);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SgiCriptoException("Llave PKCS8 Malformada", 151);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SgiCriptoException("Llave PKCS8 Malformada", 151);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException("Llave PKCS8 Malformada", 151);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SgiCriptoException("Llave PKCS8 Malformada", 151);
        }
    }

    private PrivateKeyInfo obtienePKInfo(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, byte[] byArray) throws SgiCriptoException {
        PrivateKeyInfo privateKeyInfo = null;
        try {
            ParametersWithIV parametersWithIV = null;
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = null;
            BlockCipher blockCipher = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            byte[] byArray5 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            PBES2Parameters pBES2Parameters = new PBES2Parameters((DERSequence)encryptedPrivateKeyInfo.getEncryptionAlgorithm().getParameters());
            PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
            EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
            if (pBKDF2Params.getKeyLength() != null) {
                n = pBKDF2Params.getKeyLength().intValue() * 8;
            }
            n2 = pBKDF2Params.getIterationCount().intValue();
            byArray3 = pBKDF2Params.getSalt();
            pBKDF2Params = null;
            pKCS5S2ParametersGenerator.init(byArray, byArray3, n2);
            byArray3 = null;
            String string = pBES2Parameters.getEncryptionScheme().getObjectId().getId();
            pBES2Parameters = null;
            blockCipher = this.getAlgortimosSimetrico(string);
            if (blockCipher == null) {
                throw new SgiCriptoException("Algoritmo " + string + " no soportado.", 152);
            }
            if (blockCipher instanceof DESedeEngine) {
                n = 192;
                byArray2 = ((ASN1OctetString)encryptionScheme.getObject()).getOctets();
            } else if (blockCipher instanceof DESEngine) {
                n = 64;
                byArray2 = ((ASN1OctetString)encryptionScheme.getObject()).getOctets();
            } else if (blockCipher instanceof AESEngine) {
                n = 256;
                byArray2 = ((ASN1OctetString)encryptionScheme.getObject()).getOctets();
            } else if (blockCipher instanceof RC2Engine) {
                DERObject dERObject = encryptionScheme.getParameters().getDERObject();
                DEROctetString dEROctetString = (DEROctetString)ASN1Sequence.getInstance(dERObject).getObjectAt(1);
                byArray2 = dEROctetString.getOctets();
            }
            encryptionScheme = null;
            paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(blockCipher));
            blockCipher = null;
            parametersWithIV = new ParametersWithIV(((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(n), byArray2);
            byArray2 = null;
            pKCS5S2ParametersGenerator = null;
            ((BufferedBlockCipher)paddedBufferedBlockCipher).init(false, parametersWithIV);
            parametersWithIV = null;
            byArray4 = encryptedPrivateKeyInfo.getEncryptedData();
            byArray5 = new byte[((BufferedBlockCipher)paddedBufferedBlockCipher).getOutputSize(byArray4.length)];
            n3 = ((BufferedBlockCipher)paddedBufferedBlockCipher).processBytes(byArray4, 0, byArray4.length, byArray5, 0);
            byArray4 = null;
            n3 += ((BufferedBlockCipher)paddedBufferedBlockCipher).doFinal(byArray5, n3);
            privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(byArray5));
            n3 = 0;
            paddedBufferedBlockCipher = null;
            byArray5 = null;
        }
        catch (DataLengthException dataLengthException) {
            throw new SgiCriptoException(dataLengthException.getMessage(), 150);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SgiCriptoException(illegalStateException.getMessage(), 150);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SgiCriptoException(invalidCipherTextException.getMessage(), 150);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException(iOException.getMessage(), 150);
        }
        return privateKeyInfo;
    }

    private PrivateKey getLlavePriv(InputStream inputStream, byte[] byArray) throws SgiCriptoException {
        try {
            PrivateKeyInfo privateKeyInfo;
            String string;
            PrivateKey privateKey;
            KeyFactory keyFactory;
            RSAPrivateKeySpec rSAPrivateKeySpec;
            DERObject dERObject;
            RSAPrivateKeyStructure rSAPrivateKeyStructure;
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
            block5: {
                encryptedPrivateKeyInfo = null;
                rSAPrivateKeyStructure = null;
                ASN1InputStream aSN1InputStream = null;
                dERObject = null;
                rSAPrivateKeySpec = null;
                keyFactory = null;
                privateKey = null;
                string = null;
                privateKeyInfo = null;
                aSN1InputStream = new ASN1InputStream(inputStream);
                dERObject = aSN1InputStream.readObject();
                if (dERObject == null) {
                    return null;
                }
                aSN1InputStream = null;
                encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo((ASN1Sequence)dERObject);
                try {
                    privateKeyInfo = this.obtienePKInfoPKCS8(encryptedPrivateKeyInfo, new String(byArray));
                }
                catch (SgiCriptoException sgiCriptoException) {
                    if (sgiCriptoException.getError() != 151) break block5;
                    privateKeyInfo = this.obtienePKInfo(encryptedPrivateKeyInfo, byArray);
                }
            }
            encryptedPrivateKeyInfo = null;
            dERObject = null;
            dERObject = privateKeyInfo.getPrivateKey();
            rSAPrivateKeyStructure = RSAPrivateKeyStructure.getInstance(dERObject);
            rSAPrivateKeySpec = new RSAPrivateKeySpec(rSAPrivateKeyStructure.getModulus(), rSAPrivateKeyStructure.getPrivateExponent());
            dERObject = null;
            rSAPrivateKeyStructure = null;
            string = privateKeyInfo.getAlgorithmId().getObjectId().getId();
            keyFactory = KeyFactory.getInstance(string, "BC");
            privateKey = keyFactory.generatePrivate(rSAPrivateKeySpec);
            privateKeyInfo = null;
            string = null;
            keyFactory = null;
            rSAPrivateKeySpec = null;
            return privateKey;
        }
        catch (Exception exception) {
            throw new SgiCriptoException("Llave privada estropeada o mal formada. [ " + exception.getMessage() + "]", 150);
        }
    }

    private BlockCipher getAlgortimosSimetrico(String string) {
        BlockCipher blockCipher = null;
        if (string.compareTo("1.3.14.3.2.7") == 0) {
            blockCipher = new DESEngine();
        } else if (string.compareTo("1.3.14.3.2.17") == 0 || string.compareTo("1.2.840.113549.3.7") == 0) {
            blockCipher = new DESedeEngine();
        } else if (string.compareTo("2.16.840.1.101.3.4.1.42") == 0) {
            blockCipher = new AESEngine();
        } else if (string.compareTo("1.2.840.113549.3.2") == 0) {
            blockCipher = new RC2Engine();
        }
        return blockCipher;
    }

    private String getPBE(String string) {
        String string2 = null;
        if (string.compareTo("1.2.840.113549.1.5.3") == 0) {
            string2 = "PBEWithMD5AndDES";
        }
        if (string.compareTo("1.2.840.113549.1.5.1") == 0) {
            string2 = "PBEWithMD2AndDES";
        }
        return string2;
    }
}

