/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import mx.gob.sat.sgi.SgiCripto.CCifradoAsimetrico;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.SgiDigest;
import mx.gob.sat.sgi.SgiCripto.SgiLlavePrivada;

public class SgiFirma {
    private String algoritmo = null;
    private Signature firmar = null;
    private SgiLlavePrivada llavePrivada = null;
    private SgiCertificado certificado = null;
    private boolean iniciadoFirmar = false;
    private boolean iniciadoVerificacion = false;
    private ByteArrayOutputStream mensaje_ori = null;
    private byte[] digestion_firma = null;
    private int iden_algo = 0;

    private void ver_SgiFirma() {
    }

    public void iniciaGen(SgiLlavePrivada sgiLlavePrivada, int n) throws SgiCriptoException {
        try {
            this.algoritmo = this.getAlgoritmo(n);
            this.llavePrivada = sgiLlavePrivada;
            this.firmar = Signature.getInstance(this.algoritmo);
            this.firmar.initSign(this.llavePrivada.getLlave());
            this.iniciadoFirmar = true;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SgiCriptoException("Llave privada invalida.", 316);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException("Error en algoritmo.", 306);
        }
    }

    public void genFirmaIni(SgiLlavePrivada sgiLlavePrivada, int n) throws SgiCriptoException {
        this.iniciaGen(sgiLlavePrivada, n);
    }

    public void genFirmaProceso(byte[] byArray, int n) throws SgiCriptoException {
        if (this.iniciadoFirmar) {
            try {
                this.firmar.update(byArray, 0, n);
            }
            catch (SignatureException signatureException) {
                throw new SgiCriptoException("Al agregar la parte del mensaje.", 307);
            }
        } else {
            throw new SgiCriptoException("Objeto no iniciado para firmar.", 1000);
        }
    }

    public byte[] genFirmaFin() throws SgiCriptoException {
        byte[] byArray = null;
        if (this.iniciadoFirmar) {
            try {
                byArray = this.firmar.sign();
            }
            catch (SignatureException signatureException) {
                throw new SgiCriptoException("En la generacion de la firma.", 308);
            }
        } else {
            throw new SgiCriptoException("Objeto no iniciado para firmar.", 1000);
        }
        return byArray;
    }

    public byte[] genFirma(SgiLlavePrivada sgiLlavePrivada, int n, byte[] byArray, int n2) throws SgiCriptoException {
        this.genFirmaIni(sgiLlavePrivada, n);
        if (this.iniciadoFirmar) {
            this.genFirmaProceso(byArray, n2);
            return this.genFirmaFin();
        }
        throw new SgiCriptoException("Objeto no iniciado para firmar.", 1000);
    }

    public void iniciaVer(SgiCertificado sgiCertificado) throws SgiCriptoException {
        if (sgiCertificado == null) {
            throw new SgiCriptoException("Certificado no iniciado.", -4);
        }
        this.certificado = sgiCertificado;
        this.mensaje_ori = new ByteArrayOutputStream();
        this.iniciadoVerificacion = true;
    }

    public void verFirmaIni(byte[] byArray, int n) throws SgiCriptoException {
        if (!this.iniciadoVerificacion) {
            throw new SgiCriptoException("Objeto no iniciado para Verificar.", 1000);
        }
        byte[] byArray2 = this.descifrado(byArray);
        this.iden_algo = this.obtieneIdenAlgoritmo(byArray2);
        this.digestion_firma = this.obtieneDigFirma(this.iden_algo, byArray2);
        this.iniciadoVerificacion = true;
    }

    public void verFirmaProceso(byte[] byArray, int n) throws SgiCriptoException {
        try {
            this.mensaje_ori.write(byArray);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Objeto no iniciado para Verificar.", 1000);
        }
    }

    public boolean verFirmaFin() throws SgiCriptoException {
        if (this.iniciadoVerificacion) {
            byte[] byArray = this.digestion(this.iden_algo);
            return this.compara(this.digestion_firma, byArray);
        }
        throw new SgiCriptoException("Objeto no iniciado para Verificar.", 1000);
    }

    private byte[] obtieneDigFirma(int n, byte[] byArray) throws SgiCriptoException {
        int n2 = 0;
        byte[] byArray2 = null;
        if (this.iniciadoVerificacion) {
            switch (n) {
                case 2: 
                case 4: {
                    n2 = 18;
                    break;
                }
                case 9: {
                    n2 = 15;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    n2 = 19;
                }
            }
            if (n2 != 0) {
                int n3 = byArray.length - n2;
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
            }
        } else {
            throw new SgiCriptoException("Objeto no iniciado para Verificar.", 1000);
        }
        return byArray2;
    }

    private byte[] digestion(int n) throws SgiCriptoException {
        if (this.iniciadoVerificacion) {
            SgiDigest sgiDigest = null;
            byte[] byArray = null;
            byte[] byArray2 = null;
            sgiDigest = new SgiDigest();
            byArray2 = this.mensaje_ori.toByteArray();
            byArray = sgiDigest.genDigest(n, byArray2, byArray2.length);
            return byArray;
        }
        throw new SgiCriptoException("Objeto no iniciado para Verificar.", 1000);
    }

    private byte[] descifrado(byte[] byArray) throws SgiCriptoException {
        CCifradoAsimetrico cCifradoAsimetrico = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray2 = null;
        if (this.iniciadoVerificacion) {
            if (byArray == null || byArray.length == 0) {
                throw new SgiCriptoException("Firma no iniciada.", 305);
            }
            cCifradoAsimetrico = new CCifradoAsimetrico();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byteArrayOutputStream = new ByteArrayOutputStream();
            cCifradoAsimetrico.descifrarbloques(this.certificado.getLlave(), 2, byteArrayInputStream, byteArrayOutputStream);
            cCifradoAsimetrico = null;
            byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        throw new SgiCriptoException("Objeto no iniciado para Verificar.", 1000);
    }

    private String getAlgoritmo(int n) throws SgiCriptoException {
        String string = null;
        switch (n) {
            case 1: {
                string = "GOST3411withRSA";
                break;
            }
            case 2: {
                string = "MD2withRSA";
                break;
            }
            case 3: {
                string = "MD4withRSA";
                break;
            }
            case 4: {
                string = "MD5withRSA";
                break;
            }
            case 5: {
                string = "RIPEMD128withRSA";
                break;
            }
            case 6: {
                string = "RIPEMD160withRSA";
                break;
            }
            case 7: {
                string = "IPEMD256withRSA";
                break;
            }
            case 8: {
                string = "RIPEMD320withRSA";
                break;
            }
            case 9: {
                string = "Sha1withRSA";
                break;
            }
            case 10: {
                string = "Sha1withRSA";
                break;
            }
            case 11: {
                string = "SHA224withRSA";
                break;
            }
            case 12: {
                string = "SHA384withRSA";
                break;
            }
            case 13: {
                string = "SHA512withRSA";
                break;
            }
            case 14: {
                string = "TigerwithRSA";
                break;
            }
            case 15: {
                string = "WhirlpoolwithRSA";
                break;
            }
            default: {
                throw new SgiCriptoException("Algoritmo no soportado", 600);
            }
        }
        return string;
    }

    private boolean compara(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    private int obtieneIdenAlgoritmo(byte[] byArray) {
        int n = 0;
        if (byArray[0] != 48) {
            return -1;
        }
        if (byArray[1] == 32) {
            if (byArray[13] == 2) {
                n = 2;
            } else if (byArray[13] == 5) {
                n = 4;
            }
        } else if (byArray[1] == 33) {
            if (byArray[14] == 20) {
                n = 9;
            }
        } else if (byArray[1] == 49) {
            if (byArray[14] == 1) {
                n = 11;
            }
        } else if (byArray[1] == 65) {
            if (byArray[14] == 2) {
                n = 12;
            }
        } else if (byArray[1] == 81) {
            if (byArray[14] == 3) {
                n = 13;
            }
        } else {
            n = -1;
        }
        return n;
    }
}

