/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.RIPEMD256Digest;
import org.bouncycastle.crypto.digests.RIPEMD320Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.digests.WhirlpoolDigest;

public class SgiDigest {
    private boolean iniciado = false;
    private Digest algoritmo_digestion = null;
    public static final int GOST3411 = 1;
    public static final int MD2 = 2;
    public static final int MD4 = 3;
    public static final int MD5 = 4;
    public static final int RIPEMD128 = 5;
    public static final int RIPEMD160 = 6;
    public static final int RIPEMD256 = 7;
    public static final int RIPEMD320 = 8;
    public static final int SHA1 = 9;
    public static final int SHA224 = 10;
    public static final int SHA256 = 11;
    public static final int SHA384 = 12;
    public static final int SHA512 = 13;
    public static final int Tiger = 14;
    public static final int Whirlpool = 15;

    private void ver_SgiDigest() {
    }

    public static int getAlgoritmoId(AlgorithmIdentifier algorithmIdentifier) throws SgiCriptoException {
        String string = algorithmIdentifier.getObjectId().getId();
        int n = -1;
        if (string.startsWith("1.2.840.113549.1.1")) {
            int n2 = Integer.decode(string.substring("1.2.840.113549.1.1".length() + 1));
            switch (n2) {
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                case 5: {
                    n = 9;
                    break;
                }
                case 11: {
                    n = 11;
                    break;
                }
                case 12: {
                    n = 12;
                    break;
                }
                case 13: {
                    n = 13;
                    break;
                }
                case 14: {
                    n = 10;
                }
            }
        } else if (string.startsWith("1.2.840.113549.1.5")) {
            int n3 = Integer.decode(string.substring("1.2.840.113549.1.5".length() + 1));
            switch (n3) {
                case 1: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 6: {
                    n = 4;
                    break;
                }
                case 10: {
                    n = 9;
                    break;
                }
                case 11: {
                    n = 9;
                }
            }
        } else if (string.equals(PKCSObjectIdentifiers.md2.getId())) {
            n = 2;
        } else if (string.equals(PKCSObjectIdentifiers.md4.getId())) {
            n = 3;
        } else if (string.equals(PKCSObjectIdentifiers.md5.getId())) {
            n = 4;
        } else if (string.equals(OIWObjectIdentifiers.md4WithRSA.getId()) || string.equals(OIWObjectIdentifiers.md4WithRSAEncryption.getId())) {
            n = 3;
        } else if (string.equals(OIWObjectIdentifiers.md5WithRSA.getId())) {
            n = 4;
        } else if (string.equals(OIWObjectIdentifiers.idSHA1.getId()) || string.equals(OIWObjectIdentifiers.dsaWithSHA1.getId()) || string.equals(OIWObjectIdentifiers.sha1WithRSA.getId())) {
            n = 9;
        } else if (string.equals(NISTObjectIdentifiers.id_sha256.getId())) {
            n = 11;
        } else if (string.equals(NISTObjectIdentifiers.id_sha384.getId())) {
            n = 12;
        } else if (string.equals(NISTObjectIdentifiers.id_sha512.getId())) {
            n = 13;
        } else if (string.equals(NISTObjectIdentifiers.id_sha224.getId())) {
            n = 10;
        } else if (string.equals(CryptoProObjectIdentifiers.gostR3411.getId())) {
            n = 1;
        } else if (string.equals(GNUObjectIdentifiers.Tiger_192.getId())) {
            n = 14;
        } else if (string.equals(TeleTrusTObjectIdentifiers.ripemd160.getId()) || string.equals(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160.getId())) {
            n = 6;
        } else if (string.equals(TeleTrusTObjectIdentifiers.ripemd128.getId()) || string.equals(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128.getId())) {
            n = 5;
        } else if (string.equals(TeleTrusTObjectIdentifiers.ripemd256.getId()) || string.equals(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256.getId())) {
            n = 7;
        } else {
            throw new SgiCriptoException("Identificador de algoritmo de digestion no implementado", 600);
        }
        return n;
    }

    public Digest genDigestIni(int n) throws SgiCriptoException {
        switch (n) {
            case 1: {
                this.algoritmo_digestion = new GOST3411Digest();
                break;
            }
            case 2: {
                this.algoritmo_digestion = new MD2Digest();
                break;
            }
            case 3: {
                this.algoritmo_digestion = new MD4Digest();
                break;
            }
            case 4: {
                this.algoritmo_digestion = new MD5Digest();
                break;
            }
            case 5: {
                this.algoritmo_digestion = new RIPEMD128Digest();
                break;
            }
            case 6: {
                this.algoritmo_digestion = new RIPEMD160Digest();
                break;
            }
            case 7: {
                this.algoritmo_digestion = new RIPEMD256Digest();
                break;
            }
            case 8: {
                this.algoritmo_digestion = new RIPEMD320Digest();
                break;
            }
            case 9: {
                this.algoritmo_digestion = new SHA1Digest();
                break;
            }
            case 10: {
                this.algoritmo_digestion = new SHA224Digest();
                break;
            }
            case 11: {
                this.algoritmo_digestion = new SHA256Digest();
                break;
            }
            case 12: {
                this.algoritmo_digestion = new SHA384Digest();
                break;
            }
            case 13: {
                this.algoritmo_digestion = new SHA512Digest();
                break;
            }
            case 14: {
                this.algoritmo_digestion = new TigerDigest();
                break;
            }
            case 15: {
                this.algoritmo_digestion = new WhirlpoolDigest();
                break;
            }
            default: {
                throw new SgiCriptoException("Algoritmo de digesti\u00c3\u00b3n inv\u00c3\u00a1lido.", 600);
            }
        }
        this.iniciado = true;
        return this.algoritmo_digestion;
    }

    public String getAlgoritmo() throws SgiCriptoException {
        if (this.iniciado) {
            return this.algoritmo_digestion.getAlgorithmName();
        }
        throw new SgiCriptoException("Objeto no inicializado", 1000);
    }

    public byte[] genDigest(int n, byte[] byArray, int n2) throws SgiCriptoException {
        this.genDigestIni(n);
        if (this.iniciado) {
            this.genDigestProceso(byArray, n2);
            return this.genDigestFin();
        }
        throw new SgiCriptoException("Objeto no inicializado", 1000);
    }

    public void genDigestProceso(byte[] byArray, int n) throws SgiCriptoException {
        if (!this.iniciado) {
            throw new SgiCriptoException("Objeto no inicializado", 1000);
        }
        this.algoritmo_digestion.update(byArray, 0, n);
    }

    public byte[] genDigestFin() throws SgiCriptoException {
        int n = 0;
        byte[] byArray = null;
        if (!this.iniciado) {
            throw new SgiCriptoException("Objeto no inicializado", 1000);
        }
        n = this.algoritmo_digestion.getDigestSize();
        byArray = new byte[n];
        this.algoritmo_digestion.doFinal(byArray, 0);
        return byArray;
    }
}

