/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.SgiLlavePrivada;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.X509CertificateObject;

public class SgiCertificado {
    public static final int FIEL = 1;
    public static final int SELLO = 2;
    public static final int DESCONOCIDO = 3;
    public static final int TC_UTF8 = 1;
    public static final int TC_ASCII = 0;
    private static final String[] keyUsagea = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
    private static final String[] keyNetscape = new String[]{"SSLClient", "SSLServer", "S/MIME", "Object Signing", "Reserved", "SSL CA", "S/MIME CA", "Object Signing CA"};
    private boolean iniciado = false;
    private int tipCadena = -1;
    private BufferedInputStream certb = null;
    int tam = 0;

    private void ver_SgiCertificado() {
    }

    public static SgiCertificado getInstance() {
        return new SgiCertificado();
    }

    public void inicia(int n, InputStream inputStream) throws SgiCriptoException {
        try {
            this.certb = new BufferedInputStream(inputStream);
            this.tam = this.certb.available();
            this.tipCadena = n;
            this.iniciado = true;
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error al leer del InputStream ", 115);
        }
    }

    public String getNumSerie() throws SgiCriptoException {
        if (this.iniciado) {
            BigInteger bigInteger = this.cargaObjX_509().getSerialNumber();
            byte[] byArray = bigInteger.toByteArray();
            return new String(byArray);
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public String getVigenciaInicial() throws SgiCriptoException {
        if (this.iniciado) {
            Date date = this.cargaObjX_509().getNotBefore();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
            return simpleDateFormat.format(date) + "Z";
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public String getVigenciaFinal() throws SgiCriptoException {
        if (this.iniciado) {
            Date date = this.cargaObjX_509().getNotAfter();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
            return simpleDateFormat.format(date) + "Z";
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public String getTipo() throws SgiCriptoException {
        if (this.iniciado) {
            return this.cargaObjX_509().getType();
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    private String getDatosEmisorSujeto(int n, int n2) throws SgiCriptoException {
        String string = null;
        if (!this.iniciado) {
            throw new SgiCriptoException("Objeto SgiCertificado no iniciado", 1000);
        }
        String[] stringArray = this.getIdenEmisor(n2);
        string = this.buscaAtrib(n, stringArray[0]);
        return string;
    }

    public String getEmisor(int n) throws SgiCriptoException {
        if (this.iniciado) {
            return this.getDatosEmisorSujeto(3, n);
        }
        return null;
    }

    public String getTitular(int n) throws SgiCriptoException {
        return this.getDatosEmisorSujeto(5, n);
    }

    public String getEmisor() throws SgiCriptoException {
        if (this.iniciado) {
            if (this.tipCadena == 1) {
                return this.cargaObjX_509().getIssuerDN().getName().toString();
            }
            if (this.tipCadena == 0) {
                return this.cargaObjX_509().getIssuerDN().getName().toString();
            }
            throw new SgiCriptoException("Codificacion no soportada.", 116);
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public String getTitular() throws SgiCriptoException {
        if (this.iniciado) {
            if (this.tipCadena == 1) {
                return this.cargaObjX_509().getSubjectDN().getName().toString();
            }
            if (this.tipCadena == 0) {
                return this.cargaObjX_509().getSubjectDN().getName().toString();
            }
            throw new SgiCriptoException("Codificacion no soportada.", 116);
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public boolean getBasicConstraints() throws SgiCriptoException {
        boolean bl = false;
        if (this.iniciado) {
            int n = this.cargaObjX_509().getBasicConstraints();
            if (n == 0) {
                bl = true;
            }
            return bl;
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public byte[] getExtension(int n) throws SgiCriptoException {
        byte[] byArray = null;
        if (this.iniciado) {
            String string = this.getIdentificador(n);
            if (string != null) {
                byArray = this.cargaObjX_509().getExtensionValue(string);
                if (byArray != null) {
                    return byArray;
                }
                throw new SgiCriptoException("No se obtuvo la extension.[ " + string + " ]", 104);
            }
            throw new SgiCriptoException("No se obtuvo el identificador.", 104);
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public byte[] getSubjectKeyIdentifier() throws SgiCriptoException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        SubjectKeyIdentifier subjectKeyIdentifier = null;
        if (this.iniciado) {
            byArray = this.cargaObjX_509().getExtensionValue("2.5.29.14");
            if (byArray != null) {
                try {
                    DEROctetString dEROctetString = (DEROctetString)new ASN1InputStream(new ByteArrayInputStream(byArray)).readObject();
                    subjectKeyIdentifier = new SubjectKeyIdentifier(dEROctetString);
                    byArray2 = subjectKeyIdentifier.getKeyIdentifier();
                    byArray3 = new byte[byArray2.length - 2];
                    System.arraycopy(byArray2, 2, byArray3, 0, byArray2.length - 2);
                    return byArray3;
                }
                catch (IOException iOException) {
                    throw new SgiCriptoException("No se pudo obtener el SubjectKeyIdentifier.", 104);
                }
            }
            throw new SgiCriptoException("El certificado no cuenta con SubjectKeyIdentifier.", 104);
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public byte[] getAuthorityKeyIdentifier(String string) throws SgiCriptoException {
        AuthorityKeyIdentifier authorityKeyIdentifier = null;
        DEROctetString dEROctetString = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.iniciado) {
            try {
                byArray = this.cargaObjX_509().getExtensionValue(string);
                dEROctetString = (DEROctetString)new ASN1InputStream(new ByteArrayInputStream(byArray)).readObject();
                authorityKeyIdentifier = new AuthorityKeyIdentifier((DERSequence)new ASN1InputStream(new ByteArrayInputStream(dEROctetString.getOctets())).readObject());
                byArray2 = authorityKeyIdentifier.getKeyIdentifier();
                return byArray2;
            }
            catch (IOException iOException) {
                throw new SgiCriptoException("No se obtuvo el AuthorityKeyIdentifier.", 104);
            }
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public byte[] getAuthorityKeyIdentifier() throws SgiCriptoException {
        AuthorityKeyIdentifier authorityKeyIdentifier = null;
        DEROctetString dEROctetString = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.iniciado) {
            try {
                byArray = this.cargaObjX_509().getExtensionValue("2.5.29.35");
                dEROctetString = (DEROctetString)new ASN1InputStream(new ByteArrayInputStream(byArray)).readObject();
                authorityKeyIdentifier = new AuthorityKeyIdentifier((DERSequence)new ASN1InputStream(new ByteArrayInputStream(dEROctetString.getOctets())).readObject());
                byArray2 = authorityKeyIdentifier.getKeyIdentifier();
                return byArray2;
            }
            catch (IOException iOException) {
                throw new SgiCriptoException("No se obtuvo el AuthorityKeyIdentifier.", 104);
            }
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public List getKeyUsageExt() throws SgiCriptoException {
        ArrayList<String> arrayList = null;
        if (this.iniciado) {
            boolean[] blArray = this.cargaObjX_509().getKeyUsage();
            if (blArray != null) {
                arrayList = new ArrayList<String>();
                int n = 0;
                while (n < blArray.length) {
                    if (blArray[n]) {
                        arrayList.add(keyUsagea[n]);
                    }
                    ++n;
                }
                return arrayList;
            }
            throw new SgiCriptoException("No se obtuvo la extension KeyUsage.", 104);
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public int getVersion() throws SgiCriptoException {
        if (this.iniciado) {
            return this.cargaObjX_509().getVersion();
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public PublicKey getLlave() throws SgiCriptoException {
        PublicKey publicKey = null;
        if (this.iniciado) {
            publicKey = this.cargaObjX_509().getPublicKey();
            return publicKey;
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    private String[] getIdenEmisor(int n) throws SgiCriptoException {
        String[] stringArray = new String[2];
        switch (n) {
            case 0: {
                stringArray[0] = "1.2.840.113549.1.9.2";
                stringArray[1] = "*";
                break;
            }
            case 1: {
                stringArray[0] = "2.5.4.45";
                stringArray[1] = "*";
                break;
            }
            case 2: {
                stringArray[0] = "2.5.4.5";
                stringArray[1] = "*";
                break;
            }
            case 20: {
                stringArray[0] = "2.5.4.3";
                stringArray[1] = "CN";
                break;
            }
            case 21: {
                stringArray[0] = "2.5.4.3";
                stringArray[1] = "*";
                break;
            }
            case 23: {
                stringArray[0] = "2.5.4.10";
                stringArray[1] = "O";
                break;
            }
            case 24: {
                stringArray[0] = "2.5.4.11";
                stringArray[1] = "OU";
                break;
            }
            case 25: {
                stringArray[0] = "1.2.840.113549.1.9.1";
                stringArray[1] = "*";
                break;
            }
            case 26: {
                stringArray[0] = "2.5.4.9";
                stringArray[1] = "*";
                break;
            }
            case 27: {
                stringArray[0] = "2.5.4.17";
                stringArray[1] = "*";
                break;
            }
            case 28: {
                stringArray[0] = "2.5.4.6";
                stringArray[1] = "C";
                break;
            }
            case 29: {
                stringArray[0] = "2.5.4.8";
                stringArray[1] = "ST";
                break;
            }
            case 30: {
                stringArray[0] = "2.5.4.7";
                stringArray[1] = "L";
                break;
            }
            case 31: {
                stringArray[0] = "2.5.4.45";
                stringArray[1] = "*";
                break;
            }
            case 32: {
                stringArray[0] = "2.5.4.5";
                stringArray[1] = "*";
                break;
            }
            default: {
                throw new SgiCriptoException("Identificador de Emisor no soportado.", 112);
            }
        }
        return stringArray;
    }

    private String getIdentificador(int n) throws SgiCriptoException {
        String string = null;
        switch (n) {
            case 0: {
                string = X509Extensions.AuthorityKeyIdentifier.getId();
                break;
            }
            case 1: {
                string = X509Extensions.SubjectKeyIdentifier.getId();
                break;
            }
            case 2: {
                string = X509Extensions.KeyUsage.getId();
                break;
            }
            case 3: {
                string = X509Extensions.BasicConstraints.getId();
                break;
            }
            case 4: {
                string = X509Extensions.ExtendedKeyUsage.getId();
                break;
            }
            case 5: {
                string = X509Extensions.CRLDistributionPoints.getId();
                break;
            }
            case 6: {
                string = X509Extensions.AuthorityInfoAccess.getId();
                break;
            }
            case 7: {
                string = X509Extensions.CertificatePolicies.getId();
                break;
            }
            case 8: {
                string = "2.16.840.1.113730.1.1";
                break;
            }
            default: {
                throw new SgiCriptoException("Identificador de Extension no soportado.", 112);
            }
        }
        return string;
    }

    public List getNetscapeTypeCert() throws SgiCriptoException {
        byte[] byArray = null;
        if (this.iniciado) {
            byArray = this.getExtension(8);
            boolean[] blArray = new boolean[8];
            int n = 0x80 & byArray[5];
            blArray[0] = n == 128;
            n = 0x40 & byArray[5];
            blArray[1] = n == 64;
            n = 0x20 & byArray[5];
            blArray[2] = n == 32;
            n = 0x10 & byArray[5];
            blArray[3] = n == 16;
            n = 8 & byArray[5];
            blArray[4] = n == 8;
            n = 4 & byArray[5];
            blArray[5] = n == 4;
            n = 2 & byArray[5];
            blArray[6] = n == 2;
            n = 1 & byArray[5];
            blArray[7] = n == 1;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (n2 < blArray.length) {
                if (blArray[n2]) {
                    arrayList.add(keyNetscape[n2]);
                }
                ++n2;
            }
            return arrayList;
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado.", 1000);
    }

    public RSAPublicKey getRSAPublicKey() throws SgiCriptoException {
        if (this.iniciado) {
            return (RSAPublicKey)this.getLlave();
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado", 1000);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean correspondeciaConLlavePrivada(SgiLlavePrivada sgiLlavePrivada) throws SgiCriptoException {
        BigInteger bigInteger;
        boolean bl = false;
        if (!this.iniciado) throw new SgiCriptoException("Objeto SgiCertificado no iniciado", 1000);
        if (sgiLlavePrivada == null) throw new SgiCriptoException("Objeto SgiLlavePrivada no iniciado.", -4);
        RSAPublicKey rSAPublicKey = this.getRSAPublicKey();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        if (bigInteger2.compareTo(bigInteger = sgiLlavePrivada.getRSAPrivateKey().getModulus()) != 0) return bl;
        return true;
    }

    public int getType() throws SgiCriptoException {
        int n = 3;
        if (!this.iniciado) {
            throw new SgiCriptoException("Objeto SgiCertificado no iniciado", 1000);
        }
        try {
            List list;
            boolean bl = this.getBasicConstraints();
            if (!bl && this.getSubjectKeyIdentifier() != null && this.getExtension(5) != null && this.getExtension(6) != null && this.getAuthorityKeyIdentifier() != null && (list = this.getKeyUsageExt()) != null) {
                List list2;
                if (list.contains(keyUsagea[0]) && list.contains(keyUsagea[1])) {
                    n = list.contains(keyUsagea[3]) && list.contains(keyUsagea[4]) ? 1 : 2;
                }
                if ((list2 = this.getNetscapeTypeCert()) != null && list.contains(keyNetscape[0]) && list.contains(keyNetscape[2])) {
                    n = 1;
                }
            }
            return n;
        }
        catch (SgiCriptoException sgiCriptoException) {
            return n;
        }
    }

    public X509CertificateObject cargaObjX_509() throws SgiCriptoException {
        X509CertificateObject x509CertificateObject = null;
        try {
            X509CertificateStructure x509CertificateStructure = this.getX509Certificate();
            x509CertificateObject = new X509CertificateObject(x509CertificateStructure);
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new SgiCriptoException(certificateParsingException.getMessage(), 1000);
        }
        return x509CertificateObject;
    }

    public void cargaCert(BufferedInputStream bufferedInputStream) throws SgiCriptoException {
        try {
            bufferedInputStream.mark(this.tam);
            if (bufferedInputStream.markSupported()) {
                bufferedInputStream.reset();
            }
        }
        catch (Exception exception) {
            throw new SgiCriptoException("Objeto SgiCertificado no iniciado. " + exception.getMessage(), 1000);
        }
    }

    private String buscaAtrib(int n, String string) throws SgiCriptoException {
        String string2;
        block5: {
            DERObject dERObject = null;
            string2 = null;
            ASN1InputStream aSN1InputStream = null;
            try {
                byte[] byArray = new byte[this.tam];
                this.certb.mark(this.tam);
                this.certb.read(byArray);
                this.certb.reset();
                aSN1InputStream = new ASN1InputStream(byArray);
                dERObject = aSN1InputStream.readObject();
                aSN1InputStream.close();
                ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Sequence.getInstance(dERObject).getObjectAt(0);
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(n);
                int n2 = 0;
                while (n2 < aSN1Sequence2.size()) {
                    DERSet dERSet = (DERSet)aSN1Sequence2.getObjectAt(n2);
                    int n3 = 0;
                    while (n3 < dERSet.size()) {
                        ASN1Sequence aSN1Sequence3 = (ASN1Sequence)dERSet.getObjectAt(n3);
                        if (aSN1Sequence3.getObjectAt(0).toString().compareTo(string) == 0) {
                            string2 = aSN1Sequence3.getObjectAt(1).toString();
                            break block5;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new SgiCriptoException(iOException.getMessage(), 1000);
            }
        }
        return string2;
    }

    public X509CertificateStructure getX509Certificate() throws SgiCriptoException {
        if (this.iniciado) {
            try {
                ASN1InputStream aSN1InputStream = null;
                this.certb.mark(this.tam);
                aSN1InputStream = new ASN1InputStream(this.certb);
                DERObject dERObject = aSN1InputStream.readObject();
                aSN1InputStream = null;
                X509CertificateStructure x509CertificateStructure = null;
                x509CertificateStructure = X509CertificateStructure.getInstance(dERObject);
                this.certb.reset();
                return x509CertificateStructure;
            }
            catch (IOException iOException) {
                throw new SgiCriptoException(iOException.getMessage(), 1000);
            }
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado", 1000);
    }

    public X509Certificate getX509_Certificate() throws SgiCriptoException {
        if (this.iniciado) {
            try {
                this.certb.mark(this.tam);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(this.certb);
                this.certb.reset();
                return x509Certificate;
            }
            catch (CertificateException certificateException) {
                throw new SgiCriptoException(certificateException.getMessage(), 1000);
            }
            catch (IOException iOException) {
                throw new SgiCriptoException(iOException.getMessage(), 1000);
            }
        }
        throw new SgiCriptoException("Objeto SgiCertificado no iniciado", 1000);
    }
}

