/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import mx.gob.sat.sgi.SgiCripto.SgiARAException;
import mx.gob.sat.sgi.SgiCripto.StringUtil;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.CriptografiaException;
import mx.gob.sat.sgi.SgiCripto.ara.pki.comunicacion.MensajesARA;
import mx.gob.sat.sgi.SgiCripto.ara.pki.comunicacion.MensajesException;
import mx.gob.sat.sgi.SgiCripto.ara.pki.comunicacion.operaciones.OperacionesARA;
import mx.gob.sat.sgi.SgiCripto.ara.util.ArchConfiguracion;
import mx.gob.sat.sgi.SgiCripto.ara.util.ByteCert;
import mx.gob.sat.sgi.SgiCripto.ara.util.Certificado;
import mx.gob.sat.sgi.SgiCripto.ara.util.ConvBytesException;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class SgiARA {
    private MensajesARA mensARA = null;
    private Socket sktARA = null;
    private boolean bConectado = false;
    private static String sRuta = null;
    private String sIP = null;
    private String sTiempoEspera = null;
    private int iPuerto = 0;
    private int iTiempoEspera = 20000;

    private void ver_SgiARA() {
    }

    private void Rutas_SO() {
        String string = System.getProperty("os.name");
        if (string.toUpperCase().indexOf("WINDOWS") != -1) {
            sRuta = "C://SAT//PKI//ARA//";
        } else if (string.toUpperCase().indexOf("UNIX") == -1) {
            sRuta = "/usr/local/SAT/PKI/ARA/";
        }
    }

    public void Inicia(String string) throws SgiARAException {
        this.Rutas_SO();
        if (string == null) {
            string = sRuta + "ARA.cfg";
        }
        try {
            ArchConfiguracion archConfiguracion = new ArchConfiguracion(string);
            archConfiguracion.CargaVariables();
            String string2 = "HOST";
            String string3 = "SERVICIO";
            String string4 = "TIEMPO_ESPERA";
            this.sIP = archConfiguracion.getValor(string2);
            this.sTiempoEspera = archConfiguracion.getValor(string4);
            this.iPuerto = Integer.parseInt(archConfiguracion.getValor(string3));
            if (this.sTiempoEspera != null) {
                this.iTiempoEspera = Integer.parseInt(this.sTiempoEspera);
            }
            this.Inicia((byte)0, archConfiguracion.getValor("CERT"), null, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SgiARAException(-1, fileNotFoundException.getMessage() + sRuta + string);
        }
        catch (IOException iOException) {
            throw new SgiARAException(-1, iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void Inicia(byte by, String string, String string2, String string3) throws SgiARAException {
        this.mensARA = new MensajesARA();
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            try {
                if (string != null) {
                    fileInputStream = new FileInputStream(string);
                }
                if (string2 != null) {
                    fileInputStream2 = new FileInputStream(string2);
                }
                this.mensARA.inicia(by, new OperacionesARA(), fileInputStream, null, fileInputStream2, string3);
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
            }
            catch (CriptografiaException criptografiaException) {
                throw new SgiARAException(criptografiaException.getError(), criptografiaException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SgiARAException(-1, fileNotFoundException.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                throw new SgiARAException(-1, unknownHostException.getMessage());
            }
            catch (IOException iOException) {
                throw new SgiARAException(-1, iOException.getMessage());
            }
            Object var12_7 = null;
        }
        catch (Throwable throwable) {
            Object var12_8 = null;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return;
    }

    public boolean ConectaARA() throws SgiARAException {
        if (this.mensARA == null) {
            throw new SgiARAException(-1, "ARA.ConectaARA(...):No se ha Mandado llamar el metodo Inicia. ");
        }
        try {
            if (!this.mensARA.getIniciado()) {
                throw new SgiARAException(-1, "ARA.ConectaARA(...):No se ha iniciado MensajesARA. ");
            }
            this.sktARA = new Socket(this.sIP, this.iPuerto);
            if (this.sktARA != null) {
                this.bConectado = this.mensARA.ConectaARA(this.instream(this.sktARA), this.outstream(this.sktARA));
            }
            return this.bConectado;
        }
        catch (CriptografiaException criptografiaException) {
            throw new SgiARAException(criptografiaException.getError(), criptografiaException.getMessage());
        }
        catch (MensajesException mensajesException) {
            throw new SgiARAException(mensajesException.getError(), mensajesException.getMessage());
        }
        catch (ConvBytesException convBytesException) {
            throw new SgiARAException(convBytesException.getError(), convBytesException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SgiARAException(-1, fileNotFoundException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SgiARAException(-1, unknownHostException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SgiARAException(-1, invalidCipherTextException.getMessage());
        }
        catch (IOException iOException) {
            throw new SgiARAException(-1, iOException.getMessage());
        }
    }

    public boolean DesconectaARA() throws SgiARAException {
        boolean bl = false;
        try {
            bl = this.mensARA.DesconectaARA(this.instream(this.sktARA), this.outstream(this.sktARA));
            this.sktARA.close();
        }
        catch (CriptografiaException criptografiaException) {
            throw new SgiARAException(criptografiaException.getError(), criptografiaException.getMessage());
        }
        catch (MensajesException mensajesException) {
            throw new SgiARAException(mensajesException.getError(), mensajesException.getMessage());
        }
        catch (ConvBytesException convBytesException) {
            throw new SgiARAException(convBytesException.getError(), convBytesException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SgiARAException(-1, fileNotFoundException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SgiARAException(-1, unknownHostException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SgiARAException(-1, invalidCipherTextException.getMessage());
        }
        catch (IOException iOException) {
            throw new SgiARAException(-1, iOException.getMessage());
        }
        return bl;
    }

    public boolean KeepaliveARA() throws SgiARAException {
        try {
            this.mensARA.setMensaje("PKI_KEEPALIVE", null, null);
            this.mensARA.write(this.outstream(this.sktARA));
            this.mensARA.read(this.instream(this.sktARA));
            if (this.mensARA.esOperacion("PKI_KEEPALIVE")) {
                return true;
            }
        }
        catch (MensajesException mensajesException) {
            throw new SgiARAException(mensajesException.getError(), mensajesException.getMessage());
        }
        catch (IOException iOException) {
            throw new SgiARAException(-1, iOException.getMessage());
        }
        catch (ConvBytesException convBytesException) {
            throw new SgiARAException(convBytesException.getError(), convBytesException.getMessage());
        }
        catch (CriptografiaException criptografiaException) {
            throw new SgiARAException(criptografiaException.getError(), criptografiaException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SgiARAException(-1, invalidCipherTextException.getMessage());
        }
        return false;
    }

    public Certificado SolCDxNS(String string) throws SgiARAException {
        Certificado certificado = null;
        ByteCert byteCert = null;
        if (string == null) {
            throw new SgiARAException(-1, "Numero de Serie en null.");
        }
        if (!this.bConectado) {
            throw new SgiARAException(-1, "No esta conectado a la ARA.");
        }
        String[] stringArray = new String[]{string};
        String[] stringArray2 = null;
        try {
            if (this.mensARA.setMensaje("SOLCERTARAF", stringArray, null)) {
                this.mensARA.write(this.outstream(this.sktARA));
                this.mensARA.read(this.instream(this.sktARA));
                if (this.mensARA.getIOperacion() == 20) {
                    certificado = new Certificado();
                    byteCert = new ByteCert();
                    if (byteCert == null) {
                        throw new SgiARAException(-1, "El buffer no esta inicializado.");
                    }
                    stringArray2 = this.mensARA.getMensaje(true, byteCert);
                    certificado.setEstado(stringArray2[0]);
                    certificado.setTipoCert(stringArray2[1]);
                    certificado.setVigenciaFinal(stringArray2[3]);
                    certificado.setVigenciaInicial(stringArray2[2]);
                    certificado.setCertificado(byteCert);
                    return certificado;
                }
                stringArray2 = this.mensARA.getMensaje(false, null);
                throw new SgiARAException(Integer.parseInt(stringArray2[0]), stringArray2[1]);
            }
            return certificado;
        }
        catch (CriptografiaException criptografiaException) {
            throw new SgiARAException(criptografiaException.getError(), criptografiaException.getMessage());
        }
        catch (MensajesException mensajesException) {
            throw new SgiARAException(mensajesException.getError(), mensajesException.getMessage());
        }
        catch (ConvBytesException convBytesException) {
            throw new SgiARAException(convBytesException.getError(), convBytesException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SgiARAException(-1, fileNotFoundException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SgiARAException(-1, unknownHostException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SgiARAException(-1, invalidCipherTextException.getMessage());
        }
        catch (IOException iOException) {
            throw new SgiARAException(-1, iOException.getMessage());
        }
    }

    public Certificado SolEdoCDxNS(String string) throws SgiARAException {
        Certificado certificado = null;
        if (string == null) {
            throw new SgiARAException(-1, "Numero de Serie en null.");
        }
        if (!this.bConectado) {
            throw new SgiARAException(-1, "No esta conectado a la ARA.");
        }
        String[] stringArray = new String[]{string};
        String[] stringArray2 = null;
        try {
            if (this.mensARA.setMensaje("SOLEDOCERTARA", stringArray, null)) {
                this.mensARA.write(this.outstream(this.sktARA));
                this.mensARA.read(this.instream(this.sktARA));
                stringArray2 = this.mensARA.getMensaje(false, null);
                if (this.mensARA.getIOperacion() != 6) {
                    throw new SgiARAException(Integer.parseInt(stringArray2[0]), stringArray2[1]);
                }
                certificado = new Certificado();
                certificado.setEstado(stringArray2[0]);
                certificado.setTipoCert(stringArray2[2]);
                certificado.setVigenciaFinal(stringArray2[1]);
            }
            return certificado;
        }
        catch (CriptografiaException criptografiaException) {
            throw new SgiARAException(criptografiaException.getError(), criptografiaException.getMessage());
        }
        catch (MensajesException mensajesException) {
            throw new SgiARAException(mensajesException.getError(), mensajesException.getMessage());
        }
        catch (ConvBytesException convBytesException) {
            throw new SgiARAException(convBytesException.getError(), convBytesException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SgiARAException(-1, fileNotFoundException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SgiARAException(-1, unknownHostException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SgiARAException(-1, invalidCipherTextException.getMessage());
        }
        catch (IOException iOException) {
            throw new SgiARAException(-1, iOException.getMessage());
        }
    }

    public String ConsultaRFC(String string) throws SgiARAException {
        if (string == null) {
            throw new SgiARAException(-1, "RFC null.");
        }
        if (!this.bConectado) {
            throw new SgiARAException(-1, "No esta conectado a la ARA.");
        }
        String[] stringArray = new String[]{string};
        String[] stringArray2 = null;
        try {
            if (this.mensARA.setMensaje("SOLCERTRFC", stringArray, null)) {
                this.mensARA.write(this.outstream(this.sktARA));
                this.mensARA.read(this.instream(this.sktARA));
                stringArray2 = this.mensARA.getMensaje(false, null);
                if (this.mensARA.getIOperacion() != 17) {
                    throw new SgiARAException(Integer.parseInt(stringArray2[0]), stringArray2[1]);
                }
            }
            return stringArray2[0];
        }
        catch (CriptografiaException criptografiaException) {
            throw new SgiARAException(criptografiaException.getError(), criptografiaException.getMessage());
        }
        catch (MensajesException mensajesException) {
            throw new SgiARAException(mensajesException.getError(), mensajesException.getMessage());
        }
        catch (ConvBytesException convBytesException) {
            throw new SgiARAException(convBytesException.getError(), convBytesException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SgiARAException(-1, fileNotFoundException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SgiARAException(-1, unknownHostException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SgiARAException(-1, invalidCipherTextException.getMessage());
        }
        catch (IOException iOException) {
            throw new SgiARAException(-1, iOException.getMessage());
        }
    }

    public ArrayList ConsultaRFCLista(String string, String string2, String string3, String string4) throws SgiARAException {
        ArrayList<String> arrayList = null;
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new SgiARAException(-1, "Algun parametro es null.");
        }
        if (!this.bConectado) {
            throw new SgiARAException(-1, "No esta conectado a la ARA.");
        }
        String[] stringArray = new String[]{string, string2, string3, string4};
        String[] stringArray2 = null;
        try {
            if (this.mensARA.setMensaje("SOLLISTACERTRFC", stringArray, null)) {
                this.mensARA.write(this.outstream(this.sktARA));
                this.mensARA.read(this.instream(this.sktARA));
                stringArray2 = this.mensARA.getMensaje(false, null);
                if (this.mensARA.getIOperacion() != 16) {
                    throw new SgiARAException(Integer.parseInt(stringArray2[0]), stringArray2[1]);
                }
                arrayList = new ArrayList<String>();
                String[] stringArray3 = StringUtil.split(stringArray2[0], "\\|");
                int n = 0;
                while (n < stringArray3.length) {
                    arrayList.add(stringArray3[n]);
                    ++n;
                }
                return arrayList;
            }
            return arrayList;
        }
        catch (CriptografiaException criptografiaException) {
            throw new SgiARAException(criptografiaException.getError(), criptografiaException.getMessage());
        }
        catch (MensajesException mensajesException) {
            throw new SgiARAException(mensajesException.getError(), mensajesException.getMessage());
        }
        catch (ConvBytesException convBytesException) {
            throw new SgiARAException(convBytesException.getError(), convBytesException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SgiARAException(-1, fileNotFoundException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SgiARAException(-1, unknownHostException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new SgiARAException(-1, invalidCipherTextException.getMessage());
        }
        catch (IOException iOException) {
            throw new SgiARAException(-1, iOException.getMessage());
        }
    }

    private OutputStream outstream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    private InputStream instream(Socket socket) throws IOException {
        return socket.getInputStream();
    }
}

