/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;

public class PBEKeySpec
implements KeySpec {
    private char[] password;
    private byte[] salt;
    private int iterationCount;
    private int keyLength;
    private boolean isPasswordCleared;

    public PBEKeySpec(char[] cArray) {
        if (cArray == null) {
            this.password = new char[0];
        } else {
            this.password = new char[cArray.length];
            System.arraycopy(cArray, 0, this.password, 0, cArray.length);
        }
    }

    public final char[] getPassword() {
        if (this.isPasswordCleared) {
            throw new IllegalStateException("Password has been cleared");
        }
        return this.password;
    }

    public PBEKeySpec(char[] cArray, byte[] byArray, int n, int n2) {
        this(cArray);
        if (byArray == null) {
            throw new NullPointerException("salt is null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("salt is empty");
        }
        if (n < 0) {
            throw new IllegalArgumentException("iterationCount is not positive");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("keyLength is not positive");
        }
        this.keyLength = n2;
        this.iterationCount = n;
        this.salt = (byte[])byArray.clone();
    }

    public PBEKeySpec(char[] cArray, byte[] byArray, int n) {
        this(cArray, byArray, n, 0);
    }

    public final void clearPassword() {
        int n = 0;
        while (n < this.password.length) {
            this.password[n] = '\u0000';
            ++n;
        }
        this.password = null;
        this.isPasswordCleared = true;
    }

    public final byte[] getSalt() {
        if (this.salt != null) {
            byte[] byArray = new byte[this.salt.length];
            System.arraycopy(this.salt, 0, byArray, 0, this.salt.length);
            return byArray;
        }
        return null;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }
}

