/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.JCEUtil;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public class SecretKeyFactory {
    SecretKeyFactorySpi keyFacSpi;
    Provider provider;
    String algorithm;

    protected SecretKeyFactory(SecretKeyFactorySpi secretKeyFactorySpi, Provider provider, String string) {
        this.keyFacSpi = secretKeyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static final SecretKeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        try {
            JCEUtil.Implementation implementation = JCEUtil.getImplementation("SecretKeyFactory", string, (String)null);
            if (implementation == null) {
                throw new NoSuchAlgorithmException(string + " not found");
            }
            SecretKeyFactory secretKeyFactory = new SecretKeyFactory((SecretKeyFactorySpi)implementation.getEngine(), implementation.getProvider(), string);
            return secretKeyFactory;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static final SecretKeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("No provider specified to SecretKeyFactory.getInstance()");
        }
        JCEUtil.Implementation implementation = JCEUtil.getImplementation("SecretKeyFactory", string, string2);
        if (implementation == null) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
        SecretKeyFactory secretKeyFactory = new SecretKeyFactory((SecretKeyFactorySpi)implementation.getEngine(), implementation.getProvider(), string);
        return secretKeyFactory;
    }

    public static final SecretKeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("No provider specified to SecretKeyFactory.getInstance()");
        }
        JCEUtil.Implementation implementation = JCEUtil.getImplementation("SecretKeyFactory", string, provider);
        if (implementation == null) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
        SecretKeyFactory secretKeyFactory = new SecretKeyFactory((SecretKeyFactorySpi)implementation.getEngine(), implementation.getProvider(), string);
        return secretKeyFactory;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGenerateSecret(keySpec);
    }

    public final KeySpec getKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(secretKey, clazz);
    }

    public final SecretKey translateKey(SecretKey secretKey) throws InvalidKeyException {
        return this.keyFacSpi.engineTranslateKey(secretKey);
    }
}

