/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nccd.custom.satm.x509;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JApplet;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.SgiFirma;
import mx.gob.sat.sgi.SgiCripto.SgiLlavePrivada;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class x509Applet
extends JApplet {
    private static final String VERSION = "IR8";
    private static final String CERT = "CERT";
    private String INVALID_CERT_TYPE = "Certificado Invalido: Debe usar un certificado de FIEL";
    private String INVALID_FILE = "Archivo de Certificado Invalido:";
    private String INVALID_CERT = "Certificado Invalido:";
    private String INVALID_USERID = "El certificado no contiene un RFC";
    private String CORRESPOND_ERROR = "El certificado no corresponde con la llave privada.";
    private String INVALID_CREDENTIALS_PROVIDED_ERROR = "Invalid 'credentialsProvided' value (\"$credentialsProvided\") passed to applet.";
    private String INVALID_CERT_AGC_TYPE = "Este tipo de certificado (AgC) no cuenta con los privilegios para acceder al servicio.";
    private final int AGC_CERT_TYPE = 5;
    private final String TOKEN_DELIMITER = "|";
    private final String ENCODING = System.getProperty("file.encoding");
    private String lastFolderSelected = System.getProperty("user.home");
    private String methodName = "";
    private String[] methodParameters;

    public void init() {
        System.out.println();
        System.out.println("Initializing x509Applet...Started.  Version: IR8");
        this.loadAppletParameters();
        if (this.methodName.length() > 0) {
            try {
                Method method;
                Class<?> c = this.getClass();
                if (this.methodParameters.length > 0) {
                    Class[] argTypes = new Class[this.methodParameters.length];
                    for (int i = 0; i < this.methodParameters.length; ++i) {
                        argTypes[i] = String.class;
                    }
                    method = c.getDeclaredMethod(this.methodName, argTypes);
                } else {
                    method = c.getDeclaredMethod(this.methodName, new Class[0]);
                }
                try {
                    method.setAccessible(true);
                    Object o = this.methodParameters.length > 0 ? method.invoke((Object)this, (Object[])this.methodParameters) : method.invoke((Object)this, new Object[0]);
                    System.out.println(this.methodName + "() returned: " + o);
                }
                catch (InvocationTargetException x) {
                    Throwable cause = x.getCause();
                    cause.printStackTrace();
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Initializing x509Applet...Finished");
    }

    public void initMessages(String invalidCertType, String invalidFile, String invalidCert, String invalidUserId, String correspondError) {
        this.INVALID_CERT_TYPE = invalidCertType;
        this.INVALID_FILE = invalidFile;
        this.INVALID_CERT = invalidCert;
        this.INVALID_USERID = invalidUserId;
        this.CORRESPOND_ERROR = correspondError;
    }

    public String getUserIdFromCert(String filename) throws Exception {
        try {
            SgiCertificado cert = this.getCert(filename);
            String rfcValue = cert.getTitular(1);
            if (rfcValue == null || rfcValue.length() < 1) {
                throw new Exception(this.INVALID_USERID);
            }
            String[] rfcValueArray = rfcValue.split("/");
            return rfcValueArray[0].trim();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e.getMessage().toLowerCase().contains("unknown object")) {
                msg = this.INVALID_FILE + " " + filename;
            }
            throw new Exception(msg);
        }
    }

    public String getToken(String credentialsProvided, String lookupGuid, String sessionGuid, String keyFilename, String keyPassword, String certFileName, String userId, String userName, String userPassword, String ks) throws Exception {
        String userPasswordToken;
        if (credentialsProvided == null || credentialsProvided.equalsIgnoreCase("null")) {
            throw new Exception(this.INVALID_CREDENTIALS_PROVIDED_ERROR.replaceAll("$credentialsProvided", credentialsProvided));
        }
        if (credentialsProvided.equalsIgnoreCase(CERT)) {
            System.out.println("Processing data for 'CERT' authentication... Started");
            String userIdToken = userId;
            String lookupGuidToken = lookupGuid;
            String userNameToken = "";
            String userPasswordToken2 = "";
            String clientIpToken = this.getClientIP();
            String clientMacToken = this.getClientMAC();
            SgiCertificado cert = this.getCert(certFileName);
            int certType = this.getCertType(cert);
            if (certType != 1) {
                if (certType == 5) {
                    throw new Exception(this.INVALID_CERT_AGC_TYPE);
                }
                throw new Exception(this.INVALID_CERT_TYPE + " (" + certType + ")");
            }
            if (!this.isCorrespond(certFileName, keyFilename, keyPassword)) {
                throw new Exception(this.CORRESPOND_ERROR);
            }
            String signedAndEncodedGuidToken = this.signAndEncodeValue(keyFilename, keyPassword, sessionGuid);
            String serialNumberToken = cert.getNumSerie();
            System.out.println("Processing data for 'CERT' authentication... Finished");
            return this.ENCODING + "###" + this.encode((userIdToken + "|" + serialNumberToken + "|" + lookupGuidToken + "|" + signedAndEncodedGuidToken + "|" + userNameToken + "|" + userPasswordToken2 + "|" + clientIpToken + "|" + clientMacToken + "|" + keyFilename + "|" + certFileName).getBytes());
        }
        System.out.println("Processing data for 'USERNAME-PASSWORD' authentication... Started");
        String userIdToken = "";
        String serialNumberToken = "";
        String lookupGuidToken = lookupGuid;
        String signedAndEncodedGuidToken = "";
        String userNameToken = userName;
        String clientIpToken = this.getClientIP();
        String clientMacToken = this.getClientMAC();
        if (ks != null && ks.length() > 0 && !ks.equalsIgnoreCase("null")) {
            String keySecret = new Encrypt().decrypt(ks);
            userPasswordToken = new Encrypt(new byte[]{98, 54, 23, 98, -3, 0, 34, 18, 124, 43, 28, 89, 9, 3, 6, 19}, this.decode(keySecret)).encrypt(userPassword);
        } else {
            userPasswordToken = new Encrypt().encrypt(userPassword);
        }
        System.out.println("Processing data for 'USERNAME-PASSWORD' authentication... Finished");
        return this.ENCODING + "###" + this.encode((userIdToken + "|" + serialNumberToken + "|" + lookupGuidToken + "|" + signedAndEncodedGuidToken + "|" + userNameToken + "|" + userPasswordToken + "|" + clientIpToken + "|" + clientMacToken + "|" + keyFilename + "|" + certFileName).getBytes());
    }

    public String getFirma() {
        return "";
    }

    public String showFileDialog(String title, String pattern) throws Exception {
        String filterPattern = pattern;
        if (filterPattern.startsWith("*.")) {
            filterPattern = filterPattern.substring(1);
        }
        final String filePattern = filterPattern;
        System.out.println("Showing file dialog for pattern: " + pattern + " and filter pattern: " + filterPattern);
        Frame frame = new Frame();
        Point pLoc = new Point(100, 100);
        frame.setLocation(pLoc);
        FileDialog fd = new FileDialog(frame, title, 0);
        fd.setFile(pattern);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PatternFilter
        implements FilenameFilter {
            PatternFilter() {
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(filePattern);
            }
        }
        PatternFilter pf = new PatternFilter();
        fd.setFilenameFilter(pf);
        fd.setDirectory(this.lastFolderSelected);
        fd.setResizable(true);
        fd.setVisible(true);
        if (fd.getFile() != null && !fd.getFile().equalsIgnoreCase("null")) {
            this.lastFolderSelected = fd.getDirectory();
            System.out.println("Folder of last selected file: " + this.lastFolderSelected);
            return fd.getDirectory() + fd.getFile();
        }
        return "";
    }

    private void loadAppletParameters() {
        String methodParametersParam;
        String methodNameParam = this.getParameter("methodName");
        if (methodNameParam != null && methodNameParam.length() > 0 && !methodNameParam.equalsIgnoreCase("null")) {
            this.methodName = methodNameParam;
        }
        if ((methodParametersParam = this.getParameter("methodParameters")) != null && methodParametersParam.length() > 0 && !methodParametersParam.equalsIgnoreCase("null")) {
            this.methodParameters = methodParametersParam.split(",", -1);
        }
    }

    private String getClientIP() throws Exception {
        String ipAddress = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                    StringBuilder ip = new StringBuilder();
                    while (e.hasMoreElements()) {
                        NetworkInterface ni = e.nextElement();
                        if (!ni.isUp()) continue;
                        Enumeration<InetAddress> ips = ni.getInetAddresses();
                        while (ips.hasMoreElements()) {
                            ip.append("[");
                            ip.append(ni.getName());
                            ip.append(" (");
                            ip.append(ni.getDisplayName());
                            ip.append(")");
                            ip.append("=");
                            String direccionIP = ips.nextElement().toString();
                            ip.append(direccionIP);
                            ip.append("]");
                        }
                    }
                    return ip.toString();
                }
                catch (Exception localException) {
                    System.out.println(localException.getMessage());
                    return null;
                }
            }
        });
        return ipAddress != null ? ipAddress : "";
    }

    private String getClientMAC() throws Exception {
        return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                    StringBuilder mac = new StringBuilder();
                    while (e.hasMoreElements()) {
                        byte[] arrayOfByte;
                        NetworkInterface ni = e.nextElement();
                        if (!ni.isUp() || (arrayOfByte = ni.getHardwareAddress()) == null) continue;
                        mac.append("[");
                        mac.append(ni.getName());
                        mac.append(" (");
                        mac.append(ni.getDisplayName());
                        mac.append(")");
                        mac.append("=");
                        String direccionMAC = "";
                        for (int i = 0; i < arrayOfByte.length; ++i) {
                            direccionMAC = direccionMAC + String.format("%02X%s", arrayOfByte[i], i < arrayOfByte.length - 1 ? "-" : "");
                            mac.append(String.format("%02X%s", arrayOfByte[i], i < arrayOfByte.length - 1 ? "-" : ""));
                        }
                        mac.append("]");
                    }
                    return mac.toString();
                }
                catch (Exception localException) {
                    System.out.println(localException.getMessage());
                    return "";
                }
            }
        });
    }

    private String encode(final byte[] value) throws Exception {
        return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return new BASE64Encoder().encode(value);
            }
        });
    }

    private byte[] decode(final String stringToBase64Decode) throws Exception {
        return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return new BASE64Decoder().decodeBuffer(stringToBase64Decode);
            }
        });
    }

    private SgiCertificado getCert(final String filename) throws Exception {
        return (SgiCertificado)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                SgiCertificado cert = SgiCertificado.getInstance();
                FileInputStream inputCert = new FileInputStream(filename);
                cert.inicia(1, inputCert);
                return cert;
            }
        });
    }

    private int getCertType(SgiCertificado cert) {
        int derivedType = 3;
        try {
            int certType = cert.getType();
            String numSerie = cert.getNumSerie();
            Pattern p = Pattern.compile("\\d{6}999999\\d{8}");
            Matcher m = p.matcher(numSerie);
            boolean b = m.matches();
            if (b) {
                return 5;
            }
            System.out.println(numSerie);
            switch (certType) {
                case 1: {
                    derivedType = 1;
                    break;
                }
                case 2: {
                    derivedType = 2;
                    break;
                }
                case 3: {
                    List uso = cert.getKeyUsageExt();
                    if (uso == null || !uso.contains("digitalSignature") || !uso.contains("nonRepudiation")) break;
                    if (uso.contains("keyEncipherment") || uso.contains("dataEncipherment")) {
                        if (!uso.contains("keyAgreement") || cert.getNetscapeTypeCert() == null) break;
                        derivedType = 1;
                        break;
                    }
                    if (cert.getTitular(24) == null) break;
                    try {
                        cert.getNetscapeTypeCert();
                        break;
                    }
                    catch (SgiCriptoException ex) {
                        derivedType = 2;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return derivedType;
    }

    private boolean isCorrespond(final String certFilename, final String keyFilename, final String keyPassword) throws Exception {
        Boolean correspond = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Security.addProvider(new BouncyCastleProvider());
                SgiLlavePrivada pkcs8 = new SgiLlavePrivada();
                SgiCertificado cert = SgiCertificado.getInstance();
                FileInputStream inputLlave = new FileInputStream(keyFilename);
                FileInputStream inputCert = new FileInputStream(certFilename);
                pkcs8.inicia(inputLlave, keyPassword.getBytes());
                cert.inicia(1, inputCert);
                return pkcs8.correspondenciaConCertificado(cert);
            }
        });
        return correspond;
    }

    private String signAndEncodeValue(final String keyFilename, final String keyPassword, final String value) throws Exception {
        byte[] signedBytes = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Security.addProvider(new BouncyCastleProvider());
                FileInputStream inputLlave = new FileInputStream(keyFilename);
                SgiLlavePrivada pkcs8 = new SgiLlavePrivada();
                pkcs8.inicia(inputLlave, keyPassword.getBytes());
                SgiFirma firma = new SgiFirma();
                return firma.genFirma(pkcs8, 9, value.getBytes(), value.length());
            }
        });
        return this.encode(signedBytes);
    }

    public static synchronized byte[] generateSecretKeySpec() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] key = secretKey.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        return secretKeySpec.getEncoded();
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    System.out.println("Setting system properties...");
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                    return null;
                }
            });
        }
        catch (Exception e) {
            System.out.println("Unable to set system property: apple.awt.fileDialogForDirectories");
        }
    }

    private class Encrypt {
        private Cipher encryptCipher;
        private Cipher decryptCipher;

        Encrypt() throws SecurityException {
            byte[] iv = new byte[]{98, 54, 23, 98, -3, 0, 34, 18, 124, 43, 28, 89, 9, 3, 6, 19};
            byte[] sk = new byte[]{-1, 78, 73, 35, 61, -58, -20, 46, -128, -22, -74, 2, 18, 6, 119, -5};
            this.init(iv, sk);
        }

        Encrypt(byte[] iv, byte[] sk) throws SecurityException {
            this.init(iv, sk);
        }

        private void init(byte[] iv, byte[] sk) throws SecurityException {
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            SecretKeySpec secretKeySpec = new SecretKeySpec(sk, "AES");
            try {
                this.encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                this.encryptCipher.init(1, (Key)secretKeySpec, paramSpec);
                this.decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                this.decryptCipher.init(2, (Key)secretKeySpec, paramSpec);
            }
            catch (Exception e) {
                throw new SecurityException("Could not initialize CryptoLibrary: " + e.getMessage());
            }
        }

        String encrypt(String str) throws Exception {
            try {
                byte[] data = str.getBytes("UTF-8");
                byte[] enc = this.encryptCipher.doFinal(data);
                return x509Applet.this.encode(enc);
            }
            catch (Exception e) {
                System.out.println("Could not encrypt: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }

        String decrypt(String str) throws BadPaddingException, Exception {
            byte[] dec = x509Applet.this.decode(str);
            byte[] data = this.decryptCipher.doFinal(dec);
            return new String(data, "UTF-8");
        }
    }
}

