/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    private static boolean encryptThenMAC = false;
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsStreamCipher(TlsContext tlsContext, StreamCipher streamCipher, StreamCipher streamCipher2, Digest digest, Digest digest2, int n) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        boolean bl = tlsContext.isServer();
        this.context = tlsContext;
        this.encryptCipher = streamCipher;
        this.decryptCipher = streamCipher2;
        int n2 = 2 * n + digest.getDigestSize() + digest2.getDigestSize();
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n2);
        int n3 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray, n3, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray, n3 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter3 = new KeyParameter(byArray, n3 += digest2.getDigestSize(), n);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n3 += n, n);
        if ((n3 += n) != n2) {
            throw new TlsFatalAlert(80);
        }
        if (bl) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = streamCipher2;
            this.decryptCipher = streamCipher;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = streamCipher;
            this.decryptCipher = streamCipher2;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        this.encryptCipher.init(true, keyParameter2);
        this.decryptCipher.init(false, keyParameter);
    }

    @Override
    public int getPlaintextLimit(int n) {
        return n - this.writeMac.getSize();
    }

    @Override
    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 + this.writeMac.getSize()];
        this.encryptCipher.processBytes(byArray, n, n2, byArray2, 0);
        if (encryptThenMAC) {
            byte[] byArray3 = this.writeMac.calculateMac(l, s, byArray2, 0, n2);
            System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        } else {
            byte[] byArray4 = this.writeMac.calculateMac(l, s, byArray, n, n2);
            this.encryptCipher.processBytes(byArray4, 0, byArray4.length, byArray2, n2);
        }
        return byArray2;
    }

    @Override
    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.readMac.getSize();
        if (n2 < n3) {
            throw new TlsFatalAlert(50);
        }
        int n4 = n2 - n3;
        if (encryptThenMAC) {
            int n5 = n + n2;
            this.checkMAC(l, s, byArray, n5 - n3, n5, byArray, n, n4);
            byte[] byArray2 = new byte[n4];
            this.decryptCipher.processBytes(byArray, n, n4, byArray2, 0);
            return byArray2;
        }
        byte[] byArray3 = new byte[n2];
        this.decryptCipher.processBytes(byArray, n, n2, byArray3, 0);
        this.checkMAC(l, s, byArray3, n4, n2, byArray3, 0, n4);
        return Arrays.copyOfRange(byArray3, 0, n4);
    }

    private void checkMAC(long l, short s, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws IOException {
        byte[] byArray3;
        byte[] byArray4 = Arrays.copyOfRange(byArray, n, n2);
        if (!Arrays.constantTimeAreEqual(byArray4, byArray3 = this.readMac.calculateMac(l, s, byArray2, n3, n4))) {
            throw new TlsFatalAlert(20);
        }
    }
}

