/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.MaxBytesExceededException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.util.Pack;
import org.bouncycastle.util.Strings;

public class Salsa20Engine
implements StreamCipher {
    public static final int DEFAULT_ROUNDS = 20;
    private static final int STATE_SIZE = 16;
    protected static final byte[] sigma = Strings.toByteArray("expand 32-byte k");
    protected static final byte[] tau = Strings.toByteArray("expand 16-byte k");
    protected int rounds;
    private int index = 0;
    protected int[] engineState = new int[16];
    protected int[] x = new int[16];
    private byte[] keyStream = new byte[64];
    private boolean initialised = false;
    private int cW0;
    private int cW1;
    private int cW2;

    public Salsa20Engine() {
        this(20);
    }

    public Salsa20Engine(int n) {
        if (n <= 0 || (n & 1) != 0) {
            throw new IllegalArgumentException("'rounds' must be a positive, even number");
        }
        this.rounds = n;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException(this.getAlgorithmName() + " Init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        if (byArray == null || byArray.length != this.getNonceSize()) {
            throw new IllegalArgumentException(this.getAlgorithmName() + " requires exactly " + this.getNonceSize() + " bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException(this.getAlgorithmName() + " Init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.setKey(keyParameter.getKey(), byArray);
        this.reset();
        this.initialised = true;
    }

    protected int getNonceSize() {
        return 8;
    }

    @Override
    public String getAlgorithmName() {
        String string = "Salsa20";
        if (this.rounds != 20) {
            string = string + "/" + this.rounds;
        }
        return string;
    }

    @Override
    public byte returnByte(byte by) {
        if (this.limitExceeded()) {
            throw new MaxBytesExceededException("2^70 byte limit per IV; Change IV");
        }
        if (this.index == 0) {
            this.generateKeyStream(this.keyStream);
            this.advanceCounter();
        }
        byte by2 = (byte)(this.keyStream[this.index] ^ by);
        this.index = this.index + 1 & 0x3F;
        return by2;
    }

    protected void advanceCounter() {
        this.engineState[8] = this.engineState[8] + 1;
        if (this.engineState[8] == 0) {
            this.engineState[9] = this.engineState[9] + 1;
        }
    }

    @Override
    public void processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + n2 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.limitExceeded(n2)) {
            throw new MaxBytesExceededException("2^70 byte limit per IV would be exceeded; Change IV");
        }
        for (int i = 0; i < n2; ++i) {
            if (this.index == 0) {
                this.generateKeyStream(this.keyStream);
                this.advanceCounter();
            }
            byArray2[i + n3] = (byte)(this.keyStream[this.index] ^ byArray[i + n]);
            this.index = this.index + 1 & 0x3F;
        }
    }

    @Override
    public void reset() {
        this.index = 0;
        this.resetLimitCounter();
        this.resetCounter();
    }

    protected void resetCounter() {
        this.engineState[9] = 0;
        this.engineState[8] = 0;
    }

    protected void setKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        if (byArray.length != 16 && byArray.length != 32) {
            throw new IllegalArgumentException(this.getAlgorithmName() + " requires 128 bit or 256 bit key");
        }
        int n = 0;
        this.engineState[1] = Pack.littleEndianToInt(byArray, 0);
        this.engineState[2] = Pack.littleEndianToInt(byArray, 4);
        this.engineState[3] = Pack.littleEndianToInt(byArray, 8);
        this.engineState[4] = Pack.littleEndianToInt(byArray, 12);
        if (byArray.length == 32) {
            byArray3 = sigma;
            n = 16;
        } else {
            byArray3 = tau;
        }
        this.engineState[11] = Pack.littleEndianToInt(byArray, n);
        this.engineState[12] = Pack.littleEndianToInt(byArray, n + 4);
        this.engineState[13] = Pack.littleEndianToInt(byArray, n + 8);
        this.engineState[14] = Pack.littleEndianToInt(byArray, n + 12);
        this.engineState[0] = Pack.littleEndianToInt(byArray3, 0);
        this.engineState[5] = Pack.littleEndianToInt(byArray3, 4);
        this.engineState[10] = Pack.littleEndianToInt(byArray3, 8);
        this.engineState[15] = Pack.littleEndianToInt(byArray3, 12);
        this.engineState[6] = Pack.littleEndianToInt(byArray2, 0);
        this.engineState[7] = Pack.littleEndianToInt(byArray2, 4);
        this.resetCounter();
    }

    protected void generateKeyStream(byte[] byArray) {
        Salsa20Engine.salsaCore(this.rounds, this.engineState, this.x);
        Pack.intToLittleEndian(this.x, byArray, 0);
    }

    public static void salsaCore(int n, int[] nArray, int[] nArray2) {
        if (nArray.length != 16) {
            throw new IllegalArgumentException();
        }
        if (nArray2.length != 16) {
            throw new IllegalArgumentException();
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Number of rounds must be even");
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = nArray[9];
        int n12 = nArray[10];
        int n13 = nArray[11];
        int n14 = nArray[12];
        int n15 = nArray[13];
        int n16 = nArray[14];
        int n17 = nArray[15];
        for (int i = n; i > 0; i -= 2) {
            n10 ^= Salsa20Engine.rotl((n6 ^= Salsa20Engine.rotl(n2 + n14, 7)) + n2, 9);
            n2 ^= Salsa20Engine.rotl((n14 ^= Salsa20Engine.rotl(n10 + n6, 13)) + n10, 18);
            n15 ^= Salsa20Engine.rotl((n11 ^= Salsa20Engine.rotl(n7 + n3, 7)) + n7, 9);
            n7 ^= Salsa20Engine.rotl((n3 ^= Salsa20Engine.rotl(n15 + n11, 13)) + n15, 18);
            n4 ^= Salsa20Engine.rotl((n16 ^= Salsa20Engine.rotl(n12 + n8, 7)) + n12, 9);
            n12 ^= Salsa20Engine.rotl((n8 ^= Salsa20Engine.rotl(n4 + n16, 13)) + n4, 18);
            n9 ^= Salsa20Engine.rotl((n5 ^= Salsa20Engine.rotl(n17 + n13, 7)) + n17, 9);
            n17 ^= Salsa20Engine.rotl((n13 ^= Salsa20Engine.rotl(n9 + n5, 13)) + n9, 18);
            n4 ^= Salsa20Engine.rotl((n3 ^= Salsa20Engine.rotl(n2 + n5, 7)) + n2, 9);
            n2 ^= Salsa20Engine.rotl((n5 ^= Salsa20Engine.rotl(n4 + n3, 13)) + n4, 18);
            n9 ^= Salsa20Engine.rotl((n8 ^= Salsa20Engine.rotl(n7 + n6, 7)) + n7, 9);
            n7 ^= Salsa20Engine.rotl((n6 ^= Salsa20Engine.rotl(n9 + n8, 13)) + n9, 18);
            n10 ^= Salsa20Engine.rotl((n13 ^= Salsa20Engine.rotl(n12 + n11, 7)) + n12, 9);
            n12 ^= Salsa20Engine.rotl((n11 ^= Salsa20Engine.rotl(n10 + n13, 13)) + n10, 18);
            n15 ^= Salsa20Engine.rotl((n14 ^= Salsa20Engine.rotl(n17 + n16, 7)) + n17, 9);
            n17 ^= Salsa20Engine.rotl((n16 ^= Salsa20Engine.rotl(n15 + n14, 13)) + n15, 18);
        }
        nArray2[0] = n2 + nArray[0];
        nArray2[1] = n3 + nArray[1];
        nArray2[2] = n4 + nArray[2];
        nArray2[3] = n5 + nArray[3];
        nArray2[4] = n6 + nArray[4];
        nArray2[5] = n7 + nArray[5];
        nArray2[6] = n8 + nArray[6];
        nArray2[7] = n9 + nArray[7];
        nArray2[8] = n10 + nArray[8];
        nArray2[9] = n11 + nArray[9];
        nArray2[10] = n12 + nArray[10];
        nArray2[11] = n13 + nArray[11];
        nArray2[12] = n14 + nArray[12];
        nArray2[13] = n15 + nArray[13];
        nArray2[14] = n16 + nArray[14];
        nArray2[15] = n17 + nArray[15];
    }

    protected static int rotl(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    private void resetLimitCounter() {
        this.cW0 = 0;
        this.cW1 = 0;
        this.cW2 = 0;
    }

    private boolean limitExceeded() {
        if (++this.cW0 == 0 && ++this.cW1 == 0) {
            return (++this.cW2 & 0x20) != 0;
        }
        return false;
    }

    private boolean limitExceeded(int n) {
        this.cW0 += n;
        if (this.cW0 < n && this.cW0 >= 0 && ++this.cW1 == 0) {
            return (++this.cW2 & 0x20) != 0;
        }
        return false;
    }
}

