/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.sobre;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.SgiDigest;
import mx.gob.sat.sgi.SgiCripto.SgiLlavePrivada;
import mx.gob.sat.sgi.SgiCripto.sobre.DelegadoDeFirmas;
import mx.gob.sat.sgi.SgiCripto.sobre.FirmaRSA;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignedDataParser;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.io.Streams;

public class Firmado {
    private Hashtable tabla_de_hashes = null;
    private SignedData s_data = null;
    private SignedDataParser s_data_P = null;
    protected DelegadoDeFirmas delegado = null;
    protected byte[] data_bytes = null;
    private boolean bGenerar = false;

    public void setGenerar(boolean bl) {
        this.bGenerar = bl;
    }

    private void ver_Firmado() {
    }

    public Firmado() {
        this.tabla_de_hashes = new Hashtable();
    }

    public Firmado(DelegadoDeFirmas delegadoDeFirmas) {
        this.delegado = delegadoDeFirmas;
        this.tabla_de_hashes = new Hashtable();
    }

    public boolean generaFirmado(SgiCertificado[] sgiCertificadoArray, SgiLlavePrivada[] sgiLlavePrivadaArray, int[] nArray, InputStream inputStream, OutputStream outputStream) throws SgiCriptoException, IOException {
        this.bGenerar = true;
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            X509Certificate x509Certificate = sgiCertificadoArray[0].getX509_Certificate();
            arrayList.add(x509Certificate);
            JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
            ContentSigner contentSigner = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(sgiLlavePrivadaArray[0].getLlave());
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            cMSSignedDataStreamGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(contentSigner, x509Certificate));
            cMSSignedDataStreamGenerator.addCertificates(jcaCertStore);
            outputStream = cMSSignedDataStreamGenerator.open(outputStream, true);
            Streams.pipeAll(inputStream, outputStream);
            outputStream.close();
            return true;
        }
        catch (SgiCriptoException sgiCriptoException) {
            throw new SgiCriptoException(sgiCriptoException.getMessage(), 1);
        }
        catch (CMSException cMSException) {
            throw new SgiCriptoException(cMSException.getMessage(), 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SgiCriptoException(illegalArgumentException.getMessage(), 1);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SgiCriptoException(certificateEncodingException.getMessage(), 1);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new SgiCriptoException(operatorCreationException.getMessage(), 1);
        }
    }

    public SignedData getSignedData(ASN1EncodableVector aSN1EncodableVector, ASN1EncodableVector aSN1EncodableVector2, ASN1EncodableVector aSN1EncodableVector3, InputStream inputStream) throws IOException {
        ASN1Integer aSN1Integer = new ASN1Integer(1L);
        DLSet dLSet = new DLSet(aSN1EncodableVector);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(this.readDatos(inputStream)));
        DLSet dLSet2 = new DLSet(aSN1EncodableVector3);
        ASN1Set aSN1Set = null;
        DLSet dLSet3 = new DLSet(aSN1EncodableVector2);
        return new SignedData(aSN1Integer, dLSet, contentInfo, dLSet2, aSN1Set, dLSet3);
    }

    public byte[] getEncryptedDigest(BufferedInputStream bufferedInputStream, AlgorithmIdentifier algorithmIdentifier, SgiLlavePrivada sgiLlavePrivada) throws IOException, SgiCriptoException {
        byte[] byArray = null;
        byte[] byArray2 = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(byArray2);
        byte[] byArray3 = this.getDigest(byArray2, algorithmIdentifier);
        if (byArray3 == null) {
            return null;
        }
        FirmaRSA firmaRSA = null;
        if (firmaRSA == null) {
            firmaRSA = new FirmaRSA();
        }
        byArray = firmaRSA.getFirmaCifrada(byArray3, algorithmIdentifier, sgiLlavePrivada);
        firmaRSA = null;
        byArray3 = null;
        return byArray;
    }

    protected byte[] readDatos(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        if (byArray == null) {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        return byArray;
    }

    protected byte[] readDatosEnPartes(InputStream inputStream, long l) throws IOException {
        byte[] byArray = null;
        int n = inputStream.available();
        long l2 = (long)n / l;
        if (byArray == null) {
            byArray = new byte[(int)l2];
            inputStream.read(byArray);
        }
        return byArray;
    }

    public byte[] getDigest(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) throws SgiCriptoException {
        byte[] byArray2 = null;
        String string = (String)this.tabla_de_hashes.get(algorithmIdentifier);
        if (string == null) {
            SgiDigest sgiDigest = new SgiDigest();
            byArray2 = sgiDigest.genDigest(SgiDigest.getAlgoritmoId(algorithmIdentifier), byArray, byArray.length);
            this.tabla_de_hashes.put(algorithmIdentifier, new String(byArray2));
        } else {
            byArray2 = string.getBytes();
        }
        return byArray2;
    }

    public boolean verifica(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, byte[] byArray2, X509CertificateStructure x509CertificateStructure) throws IOException, SgiCriptoException {
        SgiCertificado sgiCertificado = SgiCertificado.getInstance();
        sgiCertificado.inicia(1, new ByteArrayInputStream(x509CertificateStructure.getEncoded("DER")));
        this.delegado = new FirmaRSA();
        byte[] byArray3 = this.delegado.getFirmaPlana(byArray2, sgiCertificado);
        byte[] byArray4 = this.getDigest(byArray, algorithmIdentifier);
        return Arrays.equals(byArray3, byArray4);
    }

    public boolean inicia(CMSSignedDataParser cMSSignedDataParser) {
        try {
            int n = cMSSignedDataParser.getVersion();
            InputStream inputStream = cMSSignedDataParser.getSignedContent().getContentStream();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(new ASN1InputStream(inputStream).readObject());
            this.s_data = new SignedData(aSN1Sequence);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public boolean inicia(ASN1Encodable aSN1Encodable) throws IOException, SgiCriptoException {
        this.s_data = new SignedData((ASN1Sequence)aSN1Encodable);
        return true;
    }

    protected boolean procesaFirma(byte[] byArray, X509CertificateStructure x509CertificateStructure, SignerInfo signerInfo) throws IOException, SgiCriptoException {
        AlgorithmIdentifier algorithmIdentifier = signerInfo.getDigestAlgorithm();
        byte[] byArray2 = signerInfo.getEncryptedDigest().getOctets();
        ASN1Set aSN1Set = signerInfo.getAuthenticatedAttributes();
        if (aSN1Set == null) {
            return this.verifica(byArray, algorithmIdentifier, byArray2, x509CertificateStructure);
        }
        return this.verifica(aSN1Set.getEncoded("DER"), algorithmIdentifier, byArray2, x509CertificateStructure);
    }

    public boolean procesa(OutputStream outputStream, X509CertificateStructure x509CertificateStructure) throws IOException, SgiCriptoException {
        ContentInfo contentInfo = this.s_data.getContentInfo();
        X509CertificateStructure x509CertificateStructure2 = null;
        if (contentInfo.getContentType().equals(CMSObjectIdentifiers.data)) {
            Object object;
            if (x509CertificateStructure != null) {
                x509CertificateStructure2 = x509CertificateStructure;
            } else {
                object = this.extraerCertificados(null);
                if (((X509CertificateStructure[])object).length > 0) {
                    x509CertificateStructure2 = this.extraerCertificados(null)[0];
                } else {
                    throw new SgiCriptoException("El sobre no contiene certificados.", 6000);
                }
            }
            object = (ASN1OctetString)contentInfo.getContent();
            this.data_bytes = ((ASN1OctetString)object).getOctets();
            ASN1Set aSN1Set = this.s_data.getSignerInfos();
            SignerInfo[] signerInfoArray = this.extraerSigners(aSN1Set);
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateStructure2.getIssuer(), x509CertificateStructure2.getSerialNumber().getValue());
            for (int i = 0; i < signerInfoArray.length; ++i) {
                if (!signerInfoArray[i].getIssuerAndSerialNumber().equals(issuerAndSerialNumber)) continue;
                if (this.procesaFirma(this.data_bytes, x509CertificateStructure2, signerInfoArray[i])) {
                    outputStream.write(this.data_bytes);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CertificateStructure[] extraerCertificados(ASN1Set aSN1Set) throws IOException, SgiCriptoException {
        ASN1Set aSN1Set2 = null;
        X509CertificateStructure[] x509CertificateStructureArray = null;
        if (this.s_data != null) {
            aSN1Set2 = this.s_data.getCertificates();
        } else if (aSN1Set != null) {
            aSN1Set2 = aSN1Set;
        }
        try {
            x509CertificateStructureArray = new X509CertificateStructure[aSN1Set2.size()];
            for (int i = 0; i < x509CertificateStructureArray.length; ++i) {
                DERSequence dERSequence = (DERSequence)aSN1Set2.getObjectAt(i);
                x509CertificateStructureArray[i] = new X509CertificateStructure(dERSequence);
            }
        }
        catch (NullPointerException nullPointerException) {
            x509CertificateStructureArray = new X509CertificateStructure[]{};
            return x509CertificateStructureArray;
        }
        finally {
            return x509CertificateStructureArray;
        }
    }

    protected SignerInfo[] extraerSigners(ASN1Set aSN1Set) {
        SignerInfo[] signerInfoArray = new SignerInfo[aSN1Set.size()];
        for (int i = 0; i < signerInfoArray.length; ++i) {
            DERSequence dERSequence = (DERSequence)aSN1Set.getObjectAt(i);
            signerInfoArray[i] = new SignerInfo(dERSequence);
        }
        return signerInfoArray;
    }

    public SignerInfo getSignerInfo(X509CertificateStructure x509CertificateStructure, SgiLlavePrivada sgiLlavePrivada, AlgorithmIdentifier algorithmIdentifier, BufferedInputStream bufferedInputStream) throws IOException, SgiCriptoException {
        SignerInfo signerInfo = null;
        ASN1Integer aSN1Integer = new ASN1Integer(1L);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateStructure.getIssuer(), x509CertificateStructure.getSerialNumber().getValue());
        ASN1Set aSN1Set = null;
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, null);
        byte[] byArray = this.getEncryptedDigest(bufferedInputStream, algorithmIdentifier, sgiLlavePrivada);
        DEROctetString dEROctetString = new DEROctetString(byArray);
        byArray = null;
        ASN1Set aSN1Set2 = null;
        System.out.println("getSignerInfo");
        signerInfo = new SignerInfo(aSN1Integer, issuerAndSerialNumber, algorithmIdentifier, aSN1Set, algorithmIdentifier2, dEROctetString, aSN1Set2);
        aSN1Integer = null;
        issuerAndSerialNumber = null;
        algorithmIdentifier2 = null;
        byArray = null;
        dEROctetString = null;
        return signerInfo;
    }

    public ASN1EncodableVector getSignerInfos(ASN1EncodableVector aSN1EncodableVector, SgiLlavePrivada[] sgiLlavePrivadaArray, ASN1EncodableVector aSN1EncodableVector2, BufferedInputStream bufferedInputStream) throws IOException, SgiCriptoException {
        ASN1EncodableVector aSN1EncodableVector3 = null;
        X509CertificateStructure x509CertificateStructure = null;
        if (sgiLlavePrivadaArray.length > 0 && aSN1EncodableVector.size() == sgiLlavePrivadaArray.length) {
            aSN1EncodableVector3 = new ASN1EncodableVector();
            for (int i = 0; i < sgiLlavePrivadaArray.length; ++i) {
                x509CertificateStructure = (X509CertificateStructure)aSN1EncodableVector.get(i);
                aSN1EncodableVector3.add(this.getSignerInfo(x509CertificateStructure, sgiLlavePrivadaArray[i], (AlgorithmIdentifier)aSN1EncodableVector2.get(i), bufferedInputStream));
                x509CertificateStructure = null;
            }
        }
        System.gc();
        return aSN1EncodableVector3;
    }

    public CMSSignedData getSignedData(SgiCertificado[] sgiCertificadoArray, SgiLlavePrivada[] sgiLlavePrivadaArray, int[] nArray, InputStream inputStream) throws SgiCriptoException {
        try {
            Object object;
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            for (int i = 0; i < sgiCertificadoArray.length; ++i) {
                object2 = sgiCertificadoArray[i].getX509_Certificate();
                arrayList.add((X509Certificate)object2);
                object = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(sgiLlavePrivadaArray[0].getLlave());
                cMSSignedDataStreamGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build((ContentSigner)object, (X509Certificate)object2));
            }
            cMSSignedDataStreamGenerator.addCertificates(jcaCertStore);
            OutputStream outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
            Streams.pipeAll(inputStream, outputStream);
            outputStream.close();
            object2 = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object = new CMSSignedData((InputStream)object2);
            return object;
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error IO. " + iOException.getMessage(), 6000);
        }
        catch (CMSException cMSException) {
            throw new SgiCriptoException("Error al generar el sobre. " + cMSException.getMessage(), 6000);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SgiCriptoException("Argumentos inv\u00e1lidos. " + illegalArgumentException.getMessage(), 6000);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SgiCriptoException("Error de Encoding del certificado " + certificateEncodingException.getMessage(), 6000);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new SgiCriptoException("Error de Creaci\u00f3n de operaci\u00f3n " + operatorCreationException.getMessage(), 6000);
        }
    }
}

