/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;

public class SignedAndEnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private ASN1Set recipientInfos;
    private ASN1Set digestAlgorithms;
    private EncryptedContentInfo encryptedContentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signerInfos;

    public SignedAndEnvelopedData(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = (ASN1Integer)enumeration.nextElement();
        this.recipientInfos = (ASN1Set)enumeration.nextElement();
        this.digestAlgorithms = (ASN1Set)enumeration.nextElement();
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1Primitive aSN1Primitive = (ASN1Primitive)enumeration.nextElement();
            if (aSN1Primitive instanceof DERTaggedObject) {
                DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Primitive;
                switch (dERTaggedObject.getTagNo()) {
                    case 0: {
                        this.certificates = ASN1Set.getInstance(dERTaggedObject, false);
                        break;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance(dERTaggedObject, false);
                    }
                }
                continue;
            }
            this.signerInfos = (ASN1Set)aSN1Primitive;
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getCrls() {
        return this.crls;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    @Override
    public ASN1Primitive toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.recipientInfos);
        aSN1EncodableVector.add(this.digestAlgorithms);
        aSN1EncodableVector.add(this.encryptedContentInfo);
        if (this.certificates != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.certificates));
        }
        if (this.crls != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.crls));
        }
        aSN1EncodableVector.add(this.signerInfos);
        return new BERSequence(aSN1EncodableVector);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.toASN1Object();
    }
}

