/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.ara.criptografia;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.AlgoritmoDigestion;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.CriptografiaException;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.Digestion;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.Encripcion;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.util.encoders.Base64;

public class Firma {
    private void ver_Firma() {
    }

    public static byte[] generaFirma(RSAPrivateKeyStructure rSAPrivateKeyStructure, byte[] byArray) throws CriptografiaException, InvalidCipherTextException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(AlgoritmoDigestion.idMD5), (ASN1Encodable)DERNull.INSTANCE);
        byte[] byArray2 = Firma.generaAntefirma(new ByteArrayInputStream(byArray), algorithmIdentifier, rSAPrivateKeyStructure);
        byte[] byArray3 = Encripcion.RSA(true, rSAPrivateKeyStructure, byArray2);
        return Base64.encode(byArray3);
    }

    public static boolean verificaFirma(X509Certificate x509Certificate, byte[] byArray, byte[] byArray2) throws CriptografiaException {
        byte[] byArray3 = null;
        try {
            byte[] byArray4 = Base64.decode(byArray2);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
            RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            byArray3 = Encripcion.RSA(false, rSAPublicKeyStructure, byArray4);
            DigestInfo digestInfo = DigestInfo.getInstance(ASN1Sequence.fromByteArray(byArray3));
            byte[] byArray5 = Digestion.generaDigestion(new ByteArrayInputStream(byArray), digestInfo.getAlgorithmId());
            return Arrays.equals(digestInfo.getDigest(), byArray5);
        }
        catch (IOException iOException) {
            throw new CriptografiaException(-1, "Firma.verificaFirma(...) I/O Exception. " + iOException.getMessage());
        }
    }

    private static byte[] quitaPadingPKCS1(byte[] byArray) throws CriptografiaException {
        if (byArray[0] == 1) {
            int n;
            for (n = 1; byArray[n] == -1 && n < byArray.length; ++n) {
            }
            if (n < byArray.length && byArray[n] == 0) {
                byte[] byArray2 = new byte[byArray.length - ++n];
                System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
                return byArray2;
            }
        }
        throw new CriptografiaException(-1, "Firma.quitaPaddingPKCS1(...): Formato de firma (padding) inv\u00ef\u00bf\u00bdlido");
    }

    private static byte[] generaAntefirma(Object object, AlgorithmIdentifier algorithmIdentifier, RSAPrivateKeyStructure rSAPrivateKeyStructure) throws CriptografiaException {
        int n;
        byte[] byArray = Digestion.generaDigestion((InputStream)object, algorithmIdentifier);
        RSAEngine rSAEngine = new RSAEngine();
        rSAEngine.init(true, new RSAKeyParameters(true, rSAPrivateKeyStructure.getModulus(), rSAPrivateKeyStructure.getPublicExponent()));
        int n2 = rSAEngine.getInputBlockSize();
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, byArray);
        byte[] byArray2 = null;
        try {
            byArray2 = digestInfo.getEncoded("DER");
        }
        catch (Exception exception) {
            throw new CriptografiaException(-1, "Firma.generaAntefirma(...): Error en el Encoding");
        }
        if (byArray2.length + 3 > n2) {
            throw new CriptografiaException(-1, "Firma.generaAntefirma(...): Genera antefirma");
        }
        byte[] byArray3 = new byte[n2];
        byArray3[0] = 1;
        for (n = 1; n < n2 - byArray2.length - 1; ++n) {
            byArray3[n] = -1;
        }
        byArray3[n] = 0;
        System.arraycopy(byArray2, 0, byArray3, ++n, byArray2.length);
        return byArray3;
    }
}

