/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.ara.criptografia;

import java.io.InputStream;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.CriptografiaException;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.Memoable;

public class Digestion {
    private void ver_Digestion() {
    }

    private static String toStringDigestAlgorithm(AlgorithmIdentifier algorithmIdentifier) throws CriptografiaException {
        String string = algorithmIdentifier.getObjectId().getId();
        String string2 = null;
        if (string.startsWith(PKCSObjectIdentifiers.pkcs_1.getId())) {
            String string3 = string.substring(PKCSObjectIdentifiers.pkcs_1.getId().length() + 1);
            int n = Integer.decode(string3);
            switch (n) {
                case 2: {
                    string2 = "MD2";
                    break;
                }
                case 3: {
                    string2 = "MD4";
                    break;
                }
                case 4: {
                    string2 = "MD5";
                    break;
                }
                case 5: {
                    string2 = "SHA-1";
                }
            }
        } else if (string.equals(PKCSObjectIdentifiers.md2.getId())) {
            string2 = "MD2";
        } else if (string.equals(PKCSObjectIdentifiers.md5.getId())) {
            string2 = "MD5";
        } else if (string.equals("1.3.14.3.2.26")) {
            string2 = "SHA-1";
        }
        if (string2 == null) {
            throw new CriptografiaException(-1, "Digestion.toStringDigestAlgorithm(...): Algoritmo no implementado");
        }
        return string2;
    }

    public static byte[] generaDigestion(InputStream inputStream, AlgorithmIdentifier algorithmIdentifier) throws CriptografiaException {
        String string = Digestion.toStringDigestAlgorithm(algorithmIdentifier);
        Memoable memoable = null;
        if (string.equals("MD2")) {
            memoable = new MD2Digest();
        } else if (string.equals("MD4")) {
            memoable = new MD4Digest();
        } else if (string.equals("MD5")) {
            memoable = new MD5Digest();
        } else if (string.equals("SHA-1")) {
            memoable = new SHA1Digest();
        }
        byte[] byArray = new byte[2048];
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                memoable.update(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            throw new CriptografiaException(-1, "Digestion.generaDigestion(...): Al generar la digestion" + exception.getMessage());
        }
        byArray = null;
        byte[] byArray2 = new byte[memoable.getDigestSize()];
        memoable.doFinal(byArray2, 0);
        return byArray2;
    }
}

