/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto.ara.criptografia;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import mx.gob.sat.sgi.SgiCripto.ara.criptografia.CriptografiaException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class Cripto {
    private void ver_Cripto() {
    }

    public static String NumeroAleatorio() {
        SecureRandom secureRandom = null;
        String string = System.getProperties().getProperty("os.name");
        try {
            secureRandom = string.contains("Windows") ? SecureRandom.getInstance("SHA1PRNG") : SecureRandom.getInstance("NativePRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("[Cripto.java] - No se encontr\u00f3 el algoritmo ");
            secureRandom = new SecureRandom();
        }
        secureRandom.nextBytes(new byte[20]);
        long l = 0L;
        l = secureRandom.nextLong();
        if (l <= 0L) {
            l = Math.abs(l);
        }
        return Long.toString(l);
    }

    public static void PKCS5Procesa(AlgorithmIdentifier algorithmIdentifier, InputStream inputStream, char[] cArray, OutputStream outputStream) throws CriptografiaException {
        try {
            int n;
            int n2;
            String string = algorithmIdentifier.getObjectId().getId();
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(4, (Key)secretKey, pBEParameterSpec);
            byte[] byArray = new byte[512];
            byte[] byArray2 = new byte[cipher.getOutputSize(byArray.length)];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) > -1) {
                n = cipher.update(byArray, 0, n2, byArray2);
                outputStream.write(byArray2, 0, n);
            }
            n = cipher.doFinal(byArray2, 0);
            outputStream.write(byArray2, 0, n);
        }
        catch (Exception exception) {
            String string = exception instanceof NoSuchAlgorithmException ? "Algoritmo de desencripci\u00ef\u00bf\u00bdn desconocido" : (exception instanceof InvalidKeySpecException || exception instanceof InvalidKeyException ? "Error al preparar la desencripci\u00ef\u00bf\u00bdn (" + exception.getMessage() + ")" : (exception instanceof ShortBufferException ? "Error al realizar la desencripci\u00ef\u00bf\u00bdn (buffer destino insuficiente)" : (exception instanceof IllegalBlockSizeException ? "Error al realizar la desencripci\u00ef\u00bf\u00bdn (" + exception.getMessage() + ")" : exception.getMessage())));
            throw new CriptografiaException(-1, string);
        }
    }

    public static RSAPrivateKeyStructure ObtienePvKey(InputStream inputStream, String string) throws CriptografiaException {
        PrivateKeyInfo privateKeyInfo;
        ASN1Primitive aSN1Primitive;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
        try {
            aSN1Primitive = aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new CriptografiaException(-1, "Error al leer la llave privada " + iOException.getMessage());
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(aSN1Primitive);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Cripto.PKCS5Procesa(encryptedPrivateKeyInfo.getEncryptionAlgorithm(), new ByteArrayInputStream(encryptedPrivateKeyInfo.getEncryptedData()), string.toCharArray(), byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)ASN1Sequence.fromByteArray(byArray));
        }
        catch (IOException iOException) {
            throw new CriptografiaException(-1, "Error al procesar la llave privada" + iOException.getMessage());
        }
        return new RSAPrivateKeyStructure((ASN1Sequence)privateKeyInfo.getPrivateKey());
    }

    public static X509Certificate ObtieneCert(InputStream inputStream) throws CriptografiaException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return x509Certificate;
        }
        catch (Exception exception) {
            String string = exception instanceof IOException ? "Error de lectura al cargar el certificado" : (exception instanceof CertificateException ? "Formato de certificado inv\u00ef\u00bf\u00bdlido" : "Error al cargar certificado (" + exception.getMessage() + ")");
            throw new CriptografiaException(-1, string);
        }
    }
}

