/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mx.gob.sat.sgi.SgiCripto.SgiCertificado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import mx.gob.sat.sgi.SgiCripto.SgiLlavePrivada;
import mx.gob.sat.sgi.SgiCripto.sobre.Ensobretado;
import mx.gob.sat.sgi.SgiCripto.sobre.Firmado;
import mx.gob.sat.sgi.SgiCripto.sobre.FirmadoyEnsobretado;
import mx.gob.sat.sgi.SgiCripto.sobre.Util;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class SgiSobre {
    public static final int TPKCS7_Firmado = 1;
    public static final int TPKCS7_Ensobretado = 2;
    public static final int TPKCS7_FirmadoYEnsobretado = 3;
    private boolean iniciado = false;
    private int iTipoSobre = 0;
    private Firmado sobreFirmado = null;
    private Ensobretado sobreEnsobretado = null;
    private FirmadoyEnsobretado sobreFirmadoyEnsobretado = null;

    private void ver_SgiSobre() {
    }

    public boolean inicia(InputStream inputStream) throws SgiCriptoException {
        ContentInfo contentInfo = null;
        try {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(new ASN1InputStream(inputStream).readObject());
            contentInfo = new ContentInfo(aSN1Sequence);
            if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
                this.sobreFirmado = new Firmado();
                this.sobreFirmado.inicia(contentInfo.getContent());
                this.iTipoSobre = 1;
            } else if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.envelopedData)) {
                this.sobreEnsobretado = new Ensobretado();
                this.sobreEnsobretado.inicia(contentInfo.getContent());
                this.iTipoSobre = 2;
            } else if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.signedAndEnvelopedData)) {
                this.sobreFirmadoyEnsobretado = new FirmadoyEnsobretado();
                this.sobreFirmadoyEnsobretado.inicia(contentInfo.getContent());
                this.iTipoSobre = 3;
            } else {
                throw new SgiCriptoException("Tipo de Sobre desconocido.", 4001);
            }
            this.iniciado = true;
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error al leer la estructura del Sobre.", 4000);
        }
        return this.iniciado;
    }

    public void procesa(SgiCertificado sgiCertificado, SgiCertificado sgiCertificado2, SgiLlavePrivada sgiLlavePrivada, OutputStream outputStream) throws SgiCriptoException {
        if (!this.iniciado) {
            throw new SgiCriptoException("Sobre no se ha iniciado.", 4002);
        }
        try {
            switch (this.iTipoSobre) {
                case 1: {
                    X509CertificateStructure x509CertificateStructure = null;
                    if (sgiCertificado != null) {
                        x509CertificateStructure = (X509CertificateStructure)Util.certificados(new SgiCertificado[]{sgiCertificado}).get(0);
                    }
                    this.sobreFirmado.procesa(outputStream, x509CertificateStructure);
                    break;
                }
                case 2: {
                    ASN1EncodableVector aSN1EncodableVector = Util.certificados(new SgiCertificado[]{sgiCertificado});
                    this.sobreEnsobretado.procesa((X509CertificateStructure)aSN1EncodableVector.get(0), sgiLlavePrivada, outputStream);
                    break;
                }
                case 3: {
                    X509CertificateStructure x509CertificateStructure = null;
                    X509CertificateStructure x509CertificateStructure2 = null;
                    if (sgiCertificado != null && sgiCertificado2 != null) {
                        x509CertificateStructure = (X509CertificateStructure)Util.certificados(new SgiCertificado[]{sgiCertificado}).get(0);
                        x509CertificateStructure2 = (X509CertificateStructure)Util.certificados(new SgiCertificado[]{sgiCertificado2}).get(0);
                    } else if (sgiCertificado2 != null) {
                        x509CertificateStructure2 = (X509CertificateStructure)Util.certificados(new SgiCertificado[]{sgiCertificado2}).get(0);
                    }
                    this.sobreFirmadoyEnsobretado.procesa(outputStream, x509CertificateStructure, x509CertificateStructure2, sgiLlavePrivada);
                }
            }
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Sobre no procesado.", 4002);
        }
    }

    public void genera(SgiCertificado[] sgiCertificadoArray, SgiLlavePrivada[] sgiLlavePrivadaArray, InputStream inputStream, int n, OutputStream outputStream, int n2, SgiCertificado[] sgiCertificadoArray2) throws SgiCriptoException {
        int n3 = 0;
        if (sgiCertificadoArray != null) {
            n3 = sgiCertificadoArray.length;
        } else if (sgiCertificadoArray2 != null) {
            n3 = sgiCertificadoArray2.length;
        }
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = 9;
        }
        try {
            switch (n) {
                case 1: {
                    this.sobreFirmado = new Firmado();
                    this.sobreFirmado.generaFirmado(sgiCertificadoArray, sgiLlavePrivadaArray, nArray, inputStream, outputStream);
                    break;
                }
                case 2: {
                    this.sobreEnsobretado = new Ensobretado();
                    this.sobreEnsobretado.generaEnsobretado(sgiCertificadoArray2, n2, inputStream, outputStream);
                    break;
                }
                case 3: {
                    this.sobreFirmadoyEnsobretado = new FirmadoyEnsobretado();
                    this.sobreFirmadoyEnsobretado.generaFirmadoyEnsobretado(sgiCertificadoArray2, sgiCertificadoArray, sgiLlavePrivadaArray, n2, inputStream, nArray, outputStream);
                }
            }
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Sobre no generado. " + iOException.getMessage(), 4002);
        }
    }
}

