/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;

public class SgiCadCert {
    private CertPathValidator validador = null;
    private List listaACs = null;
    private boolean iniciado = false;
    private X509Certificate root = null;
    private byte[] certificadoAvalidar = null;

    private void ver_SgiCadCert() {
    }

    private X509Certificate getCertificado(InputStream inputStream) throws SgiCriptoException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
            throw new SgiCriptoException("Error al generar X509." + certificateException.getMessage(), 701);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SgiCriptoException("El proveedor no esta cargado." + noSuchProviderException.getMessage(), 707);
        }
    }

    private void cargaCertificados(List list) throws SgiCriptoException {
        int n = list.size();
        this.listaACs = new ArrayList();
        InputStream inputStream = null;
        X509Certificate x509Certificate = null;
        if (!this.listaACs.isEmpty()) {
            this.listaACs.clear();
        }
        for (int i = 0; i < n; ++i) {
            inputStream = (InputStream)list.get(i);
            x509Certificate = this.getCertificado(inputStream);
            this.listaACs.add(x509Certificate);
        }
    }

    public void inicia(InputStream inputStream, List list) throws SgiCriptoException {
        if (this.certificadoAvalidar != null) {
            this.certificadoAvalidar = null;
        }
        this.root = this.getCertificado(inputStream);
        this.cargaCertificados(list);
        this.iniciado = true;
    }

    private boolean valida_ant(InputStream inputStream) throws SgiCriptoException {
        if (!this.iniciado) {
            throw new SgiCriptoException("Objeto SgiCadCert no iniciado.", 1000);
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        try {
            arrayList.add(this.root);
            for (int i = 0; i < this.listaACs.size(); ++i) {
                arrayList.add((X509Certificate)this.listaACs.get(i));
            }
            arrayList.add(this.getCertificado(inputStream));
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(arrayList.get(arrayList.size() - 1));
            for (int i = 0; i < this.listaACs.size(); ++i) {
                arrayList2.add(this.listaACs.get(i));
            }
            CertPath certPath = certificateFactory.generateCertPath(arrayList2);
            Set<TrustAnchor> set = Collections.singleton(new TrustAnchor(this.root, null));
            this.validador = CertPathValidator.getInstance("PKIX", "BC");
            PKIXParameters pKIXParameters = new PKIXParameters(set);
            pKIXParameters.addCertStore(certStore);
            pKIXParameters.setDate(new Date());
            pKIXParameters.setRevocationEnabled(false);
            this.validador.validate(certPath, pKIXParameters);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new SgiCriptoException("Certificado no validado." + certPathValidatorException.getMessage(), 706);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SgiCriptoException("Parametros PKIX invalidos." + invalidAlgorithmParameterException.getMessage(), 704);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException("Algoritmo no encontrado." + noSuchAlgorithmException.getMessage(), 705);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SgiCriptoException("El proveedor no esta cargado." + noSuchProviderException.getMessage(), 707);
        }
        catch (CertificateException certificateException) {
            throw new SgiCriptoException("Certificado no valido." + certificateException.getMessage(), 708);
        }
        return true;
    }

    public boolean valida(InputStream inputStream) throws SgiCriptoException {
        if (!this.iniciado) {
            throw new SgiCriptoException("Objeto SgiCadCert no iniciado.", 1000);
        }
        try {
            this.certificadoAvalidar = new byte[inputStream.available()];
            inputStream.read(this.certificadoAvalidar);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException("Error al leer el certificado a validar. " + iOException.getMessage(), 701);
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        boolean bl = false;
        int n = this.listaACs.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.isEmpty()) {
                arrayList.clear();
            }
            try {
                if (bl) break;
                arrayList.add(this.root);
                arrayList.add((X509Certificate)this.listaACs.get(i));
                arrayList.add(this.getCertificado(new ByteArrayInputStream(this.certificadoAvalidar)));
                CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
                CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "BC");
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                ArrayList arrayList2 = new ArrayList();
                arrayList2.add(arrayList.get(arrayList.size() - 1));
                arrayList2.add(this.listaACs.get(i));
                CertPath certPath = certificateFactory.generateCertPath(arrayList2);
                Set<TrustAnchor> set = Collections.singleton(new TrustAnchor(this.root, null));
                this.validador = CertPathValidator.getInstance("PKIX", "BC");
                PKIXParameters pKIXParameters = new PKIXParameters(set);
                pKIXParameters.addCertStore(certStore);
                pKIXParameters.setDate(new Date());
                pKIXParameters.setRevocationEnabled(false);
                this.validador.validate(certPath, pKIXParameters);
                bl = true;
                continue;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                if (i != n) continue;
                break;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                if (i != n) continue;
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (i != n) continue;
                break;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (i != n) continue;
                break;
            }
            catch (CertificateException certificateException) {
                if (i == n) break;
            }
        }
        return bl;
    }
}

