/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import mx.gob.sat.sgi.SgiCripto.AlgSimetrico;
import mx.gob.sat.sgi.SgiCripto.CCifrado;
import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.io.Streams;

public class CCifradoSimetrico
extends CCifrado {
    private byte[] password_cif = null;
    private String algoritmo_cif = null;
    private String algoritmo_com = null;
    private int algoritmo_llave = 0;
    private int algoritmo_iv = 8;
    private byte[] pk7_iv = null;
    private boolean iniciado = false;
    private boolean iniciadoPk7 = false;

    private void ver_CCifradoSimetrico() {
    }

    public byte[] cifrarPk7Stream(Key key, InputStream inputStream) throws SgiCriptoException {
        if (this.iniciadoPk7) {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = secureRandom.generateSeed(8);
            secureRandom.setSeed(byArray);
            byte[] byArray2 = new byte[8];
            secureRandom.nextBytes(byArray2);
            ParametersWithIV parametersWithIV = this.generaLlaveGeneral(byArray2, 1, this.algoritmo_llave, this.algoritmo_iv);
            this.pk7_iv = parametersWithIV.getIV();
            return this.cifrarPk7Stream(key, parametersWithIV.getIV(), inputStream);
        }
        return null;
    }

    public byte[] cifrarPk7(Key key, byte[] byArray) throws SgiCriptoException {
        if (this.iniciadoPk7) {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray2 = secureRandom.generateSeed(8);
            secureRandom.setSeed(byArray2);
            byte[] byArray3 = new byte[8];
            secureRandom.nextBytes(byArray3);
            ParametersWithIV parametersWithIV = this.generaLlaveGeneral(byArray3, 1, this.algoritmo_llave, this.algoritmo_iv);
            this.pk7_iv = parametersWithIV.getIV();
            return this.cifrarPk7(key, parametersWithIV.getIV(), byArray);
        }
        return null;
    }

    public byte[] getPk7IV() {
        byte[] byArray = this.pk7_iv;
        return byArray;
    }

    public byte[] cifrarPk7(Key key, byte[] byArray, byte[] byArray2) throws SgiCriptoException {
        if (this.iniciadoPk7) {
            return this.cifraGeneral(key, byArray, byArray2, 1);
        }
        return null;
    }

    public byte[] cifrarPk7Stream(Key key, byte[] byArray, InputStream inputStream) throws SgiCriptoException {
        if (this.iniciadoPk7) {
            return this.cifraGeneralStream(key, byArray, inputStream, 1);
        }
        return null;
    }

    private byte[] cifradoGeneral(byte[] byArray) throws SgiCriptoException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray2 = secureRandom.generateSeed(8);
        int n = 1;
        String string = "Salted__";
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        SecretKeySpec secretKeySpec = null;
        ParametersWithIV parametersWithIV = null;
        parametersWithIV = this.generaLlaveGeneral(byArray2, n, this.algoritmo_llave, this.algoritmo_iv);
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        secretKeySpec = new SecretKeySpec(keyParameter.getKey(), this.algoritmo_cif);
        byArray3 = this.cifraGeneral(secretKeySpec, parametersWithIV.getIV(), byArray, 1);
        if (byArray3 != null) {
            byArray4 = new byte[string.length() + byArray2.length + byArray3.length];
            System.arraycopy(string.getBytes(), 0, byArray4, 0, string.getBytes().length);
            System.arraycopy(byArray2, 0, byArray4, 8, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, 16, byArray3.length);
        }
        return byArray4;
    }

    public void inicia(int n, byte[] byArray) {
        String[] stringArray = AlgSimetrico.getAlgoritmo(n);
        this.password_cif = byArray;
        this.algoritmo_cif = stringArray[0];
        this.algoritmo_com = stringArray[1];
        this.algoritmo_llave = Integer.parseInt(stringArray[2]);
        this.algoritmo_iv = this.algoritmo_cif.compareTo("AES") == 0 ? 128 : 64;
        this.iniciado = true;
    }

    public void iniciaPk7(int n) {
        this.inicia(n, "".getBytes());
        this.iniciadoPk7 = true;
    }

    @Override
    public void cifra(InputStream inputStream, OutputStream outputStream) throws SgiCriptoException {
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            byte[] byArray2 = this.cifradoGeneral(byArray);
            outputStream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException(iOException.getMessage(), -916);
        }
    }

    @Override
    public void descifra(InputStream inputStream, OutputStream outputStream) throws SgiCriptoException {
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            byte[] byArray2 = this.descifradoGeneral(byArray);
            outputStream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new SgiCriptoException(iOException.getMessage(), -916);
        }
    }

    private byte[] descifradoGeneral(byte[] byArray) throws SgiCriptoException {
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[8];
        int n = 1;
        ParametersWithIV parametersWithIV = null;
        KeyParameter keyParameter = null;
        SecretKeySpec secretKeySpec = null;
        int n2 = byArray.length - 16;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray5, 0, 8);
        if (new String(byArray5).compareTo("Salted__") != 0) {
            throw new SgiCriptoException("Cifrado incorrrecto.", -918);
        }
        System.arraycopy(byArray, 8, byArray3, 0, 8);
        System.arraycopy(byArray, 16, byArray2, 0, n2);
        parametersWithIV = this.generaLlaveGeneral(byArray3, n, this.algoritmo_llave, this.algoritmo_iv);
        keyParameter = (KeyParameter)parametersWithIV.getParameters();
        secretKeySpec = new SecretKeySpec(keyParameter.getKey(), this.algoritmo_cif);
        byArray4 = this.cifraGeneral(secretKeySpec, parametersWithIV.getIV(), byArray2, 2);
        return byArray4;
    }

    public byte[] descifrarPk7(Key key, byte[] byArray, byte[] byArray2) throws SgiCriptoException {
        return this.cifraGeneral(key, byArray, byArray2, 2);
    }

    private byte[] cifraGeneral(Key key, byte[] byArray, byte[] byArray2, int n) throws SgiCriptoException {
        try {
            IvParameterSpec ivParameterSpec = null;
            ivParameterSpec = new IvParameterSpec(byArray);
            Cipher cipher = Cipher.getInstance(this.algoritmo_com);
            cipher.init(n, key, ivParameterSpec);
            byte[] byArray3 = cipher.doFinal(byArray2);
            return byArray3;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SgiCriptoException(illegalBlockSizeException.getMessage(), -916);
        }
        catch (BadPaddingException badPaddingException) {
            throw new SgiCriptoException(badPaddingException.getMessage(), -916);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SgiCriptoException(invalidKeyException.getMessage(), -916);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SgiCriptoException(invalidAlgorithmParameterException.getMessage(), -916);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException(noSuchAlgorithmException.getMessage(), -916);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SgiCriptoException(noSuchPaddingException.getMessage(), -916);
        }
    }

    private byte[] cifraGeneralStream(Key key, byte[] byArray, InputStream inputStream, int n) throws SgiCriptoException {
        try {
            IvParameterSpec ivParameterSpec = null;
            ivParameterSpec = new IvParameterSpec(byArray);
            Cipher cipher = Cipher.getInstance(this.algoritmo_com);
            cipher.init(n, key, ivParameterSpec);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
            Streams.pipeAll(inputStream, cipherOutputStream);
            cipherOutputStream.flush();
            cipherOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SgiCriptoException(invalidKeyException.getMessage(), -916);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SgiCriptoException(invalidAlgorithmParameterException.getMessage(), -916);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SgiCriptoException(noSuchAlgorithmException.getMessage(), -916);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SgiCriptoException(noSuchPaddingException.getMessage(), -916);
        }
        return null;
    }

    private ParametersWithIV generaLlaveGeneral(byte[] byArray, int n, int n2, int n3) {
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = null;
        ParametersWithIV parametersWithIV = null;
        openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(this.password_cif, byArray, n);
        parametersWithIV = (ParametersWithIV)openSSLPBEParametersGenerator.generateDerivedParameters(n2, n3);
        return parametersWithIV;
    }
}

