/*
 * Decompiled with CFR 0.152.
 */
package mx.gob.sat.sgi.SgiCripto;

import mx.gob.sat.sgi.SgiCripto.SgiCriptoException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class AlgSimetrico {
    public static final int AEnc_AES_128_CBC = 1;
    public static final int AEnc_AES_128_CFB = 2;
    public static final int AEnc_AES_128_OFB = 3;
    public static final int AEnc_AES_192_CBC = 4;
    public static final int AEnc_AES_192_CFB = 5;
    public static final int AEnc_AES_192_OFB = 6;
    public static final int AEnc_AES_256_CBC = 7;
    public static final int AEnc_AES_256_CFB = 8;
    public static final int AEnc_AES_256_OFB = 9;
    public static final int AEnc_AES_128 = 10;
    public static final int AEnc_AES_192 = 11;
    public static final int AEnc_AES_256 = 12;
    public static final int AEnc_DES_CBC = 13;
    public static final int AEnc_DES_CFB = 14;
    public static final int AEnc_DES_OFB = 15;
    public static final int AEnc_DES_EDE = 16;
    public static final int AEnc_DES_EDE_CFB = 17;
    public static final int AEnc_DES_EDE_OFB = 18;
    public static final int AEnc_DES_EDE_CBC = 19;
    public static final int AEnc_DES_EDE3 = 20;
    public static final int AEnc_DES_EDE3_CBC = 21;
    public static final int AEnc_DES_EDE3_CFB = 22;
    public static final int AEnc_DES_EDE3_OFB = 23;
    public static final int AEnc_RC2_CBC = 24;
    public static final int AEnc_RC2_CFB = 25;
    public static final int AEnc_RC2_OFB = 26;
    public static final int AEnc_RC4_CBC = 27;
    public static final int AEnc_RC4_CFB = 28;
    public static final int AEnc_RC4_OFB = 29;
    public static final int AEnc_BF_CBC = 30;
    public static final int AEnc_BF_CFB = 31;
    public static final int AEnc_BF_OFB = 32;

    private void ver_AlgSimetrico() {
    }

    public static String[] getAlgoritmo(int n) {
        String[] stringArray = new String[3];
        switch (n) {
            case 1: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/CBC/PKCS5Padding";
                stringArray[2] = "128";
                break;
            }
            case 2: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/CFB/PKCS5Padding";
                stringArray[2] = "128";
                break;
            }
            case 3: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/OFB/PKCS5Padding";
                stringArray[2] = "128";
                break;
            }
            case 4: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/CBC/PKCS5Padding";
                stringArray[2] = "192";
                break;
            }
            case 5: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/CFB/PKCS5Padding";
                stringArray[2] = "192";
                break;
            }
            case 6: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/OFB/PKCS5Padding";
                stringArray[2] = "192";
                break;
            }
            case 7: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/CBC/PKCS5Padding";
                stringArray[2] = "256";
                break;
            }
            case 8: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/CFB/PKCS5Padding";
                stringArray[2] = "256";
                break;
            }
            case 9: {
                stringArray[0] = "AES";
                stringArray[1] = "AES/OFB/PKCS5Padding";
                stringArray[2] = "256";
                break;
            }
            case 10: {
                stringArray[0] = "AES";
                stringArray[1] = "AES";
                stringArray[2] = "128";
                break;
            }
            case 11: {
                stringArray[0] = "AES";
                stringArray[1] = "AES";
                stringArray[2] = "192";
                break;
            }
            case 12: {
                stringArray[0] = "AES";
                stringArray[1] = "AES";
                stringArray[2] = "256";
                break;
            }
            case 13: {
                stringArray[0] = "DES";
                stringArray[1] = "DES/CBC/PKCS5Padding";
                stringArray[2] = "64";
                break;
            }
            case 14: {
                stringArray[0] = "DES";
                stringArray[1] = "DES/CFB/PKCS5Padding";
                stringArray[2] = "64";
                break;
            }
            case 15: {
                stringArray[0] = "DES";
                stringArray[1] = "DES/OFB/PKCS5Padding";
                stringArray[2] = "64";
                break;
            }
            case 19: {
                stringArray[0] = "DESEDE";
                stringArray[1] = "DESede/CBC/PKCS5Padding";
                stringArray[2] = "168";
                break;
            }
            case 17: {
                stringArray[0] = "DESede";
                stringArray[1] = "DESede/CFB/PKCS5Padding";
                stringArray[2] = "168";
                break;
            }
            case 18: {
                stringArray[0] = "DESede";
                stringArray[1] = "DESede/OFB/PKCS5Padding";
                stringArray[2] = "168";
                break;
            }
            case 20: {
                stringArray[0] = "DESede3";
                stringArray[1] = "DESede3";
                stringArray[2] = "192";
                break;
            }
            case 21: {
                stringArray[0] = "DESede3";
                stringArray[1] = "DESede3/CBC/PKCS5Padding";
                stringArray[2] = "192";
                break;
            }
            case 22: {
                stringArray[0] = "DESede3";
                stringArray[1] = "DESede3/CFB/PKCS5Padding";
                stringArray[2] = "192";
                break;
            }
            case 23: {
                stringArray[0] = "DESede3";
                stringArray[1] = "DESede3/OFB/PKCS5Padding";
                stringArray[2] = "192";
                break;
            }
            case 24: {
                stringArray[0] = "RC2";
                stringArray[1] = "RC2/CBC/PKCS5Padding";
                stringArray[2] = "40";
                break;
            }
            case 25: {
                stringArray[0] = "RC2";
                stringArray[1] = "RC2/CFB/PKCS5Padding";
                stringArray[2] = "40";
                break;
            }
            case 26: {
                stringArray[0] = "RC2";
                stringArray[1] = "RC2/OFB/PKCS5Padding";
                stringArray[2] = "40";
                break;
            }
            case 27: {
                stringArray[0] = "RC4";
                stringArray[1] = "RC4";
                stringArray[2] = "40";
                break;
            }
            case 28: {
                stringArray[0] = "RC4";
                stringArray[1] = "RC4/CFB/PKCS5Padding";
                stringArray[2] = "40";
                break;
            }
            case 29: {
                stringArray[0] = "RC4";
                stringArray[1] = "RC4/OFB/PKCS5Padding";
                stringArray[2] = "40";
                break;
            }
            case 30: {
                stringArray[0] = "Blowfish";
                stringArray[1] = "Blowfish/CBC/PKCS5Padding";
                stringArray[2] = "32";
                break;
            }
            case 31: {
                stringArray[0] = "Blowfish";
                stringArray[1] = "Blowfish/CFB/PKCS5Padding";
                stringArray[2] = "32";
                break;
            }
            case 32: {
                stringArray[0] = "Blowfish";
                stringArray[1] = "Blowfish/OFB/PKCS5Padding";
                stringArray[2] = "32";
            }
        }
        return stringArray;
    }

    public static int getAlgoritmoId(AlgorithmIdentifier algorithmIdentifier) throws SgiCriptoException {
        String string = algorithmIdentifier.getObjectId().getId();
        int n = -1;
        if (string.startsWith(NISTObjectIdentifiers.aes.getId())) {
            int n2 = Integer.decode(string.substring(NISTObjectIdentifiers.aes.getId().length() + 1));
            switch (n2) {
                case 1: {
                    n = 10;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 5: {
                    n = 10;
                    break;
                }
                case 21: {
                    n = 11;
                    break;
                }
                case 22: {
                    n = 4;
                    break;
                }
                case 23: {
                    n = 6;
                    break;
                }
                case 24: {
                    n = 5;
                    break;
                }
                case 25: {
                    n = 11;
                    break;
                }
                case 41: {
                    n = 12;
                    break;
                }
                case 42: {
                    n = 7;
                    break;
                }
                case 43: {
                    n = 9;
                    break;
                }
                case 44: {
                    n = 8;
                    break;
                }
                case 45: {
                    n = 12;
                }
            }
        } else if (string.equals(OIWObjectIdentifiers.desCBC.getId())) {
            n = 13;
        } else if (string.equals(OIWObjectIdentifiers.desCFB.getId())) {
            n = 14;
        } else if (string.equals(OIWObjectIdentifiers.desOFB.getId())) {
            n = 15;
        } else if (string.equals(PKCSObjectIdentifiers.des_EDE3_CBC.getId())) {
            n = 19;
        } else if (string.equals(PKCSObjectIdentifiers.RC2_CBC.getId())) {
            n = 24;
        } else {
            throw new SgiCriptoException("Identificador de algoritmo de cifrado no implementado", 500);
        }
        return n;
    }

    public static ASN1ObjectIdentifier getAlgoritmoObjId(int n) throws SgiCriptoException {
        switch (n) {
            case 10: {
                return NISTObjectIdentifiers.id_aes128_ECB;
            }
            case 1: {
                return NISTObjectIdentifiers.id_aes128_CBC;
            }
            case 3: {
                return NISTObjectIdentifiers.id_aes128_OFB;
            }
            case 2: {
                return NISTObjectIdentifiers.id_aes128_CFB;
            }
            case 11: {
                return NISTObjectIdentifiers.id_aes192_ECB;
            }
            case 4: {
                return NISTObjectIdentifiers.id_aes192_CBC;
            }
            case 6: {
                return NISTObjectIdentifiers.id_aes192_OFB;
            }
            case 5: {
                return NISTObjectIdentifiers.id_aes192_CFB;
            }
            case 12: {
                return NISTObjectIdentifiers.id_aes256_ECB;
            }
            case 7: {
                return NISTObjectIdentifiers.id_aes256_CBC;
            }
            case 9: {
                return NISTObjectIdentifiers.id_aes256_OFB;
            }
            case 8: {
                return NISTObjectIdentifiers.id_aes256_CFB;
            }
            case 13: {
                return OIWObjectIdentifiers.desCBC;
            }
            case 14: {
                return OIWObjectIdentifiers.desCFB;
            }
            case 15: {
                return OIWObjectIdentifiers.desOFB;
            }
            case 19: {
                return PKCSObjectIdentifiers.des_EDE3_CBC;
            }
            case 24: {
                return PKCSObjectIdentifiers.RC2_CBC;
            }
        }
        throw new SgiCriptoException("Identificador de algoritmo de encripci\u00ef\u00bf\u00bdn no implementado", 500);
    }
}

